/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util.interrupt;

import uniol.apt.util.interrupt.Interrupter;
import uniol.apt.util.interrupt.NoOpInterrupter;
import uniol.apt.util.interrupt.UncheckedInterruptedException;

public class InterrupterRegistry {
    private static final ThreadLocal<Interrupter> THREAD_LOCAL_INTERRUPTER = new ThreadLocal();
    private static final Interrupter NO_OP_INTERRUPTER = new NoOpInterrupter();

    public static void clearCurrentThreadInterrupter() {
        THREAD_LOCAL_INTERRUPTER.remove();
    }

    public static void setCurrentThreadInterrupter(Interrupter interrupter) {
        THREAD_LOCAL_INTERRUPTER.set(interrupter);
    }

    public static Interrupter getCurrentThreadInterrupter() {
        Interrupter res = THREAD_LOCAL_INTERRUPTER.get();
        if (res != null) {
            return res;
        }
        return NO_OP_INTERRUPTER;
    }

    public static void throwIfInterruptRequestedForCurrentThread() {
        if (InterrupterRegistry.getCurrentThreadInterrupter().isInterruptRequested()) {
            throw new UncheckedInterruptedException();
        }
    }
}

