/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util.equations;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.equations.InequalitySystem;
import uniol.apt.util.interrupt.InterrupterRegistry;
import uniol.apt.util.interrupt.UncheckedInterruptedException;

public class InequalitySystemSolver {
    private final Script script;
    private final List<InequalitySystem[]> systems = new LinkedList<InequalitySystem[]>();
    private final Deque<Integer> systemsLengthStack = new LinkedList<Integer>();
    private final Deque<Integer> variablesStack = new LinkedList<Integer>();

    public InequalitySystemSolver() {
        DefaultLogger logger = new DefaultLogger();
        this.script = new SMTInterpol((LogProxy)logger, new TerminationRequest(){

            @Override
            public boolean isTerminationRequested() {
                return InterrupterRegistry.getCurrentThreadInterrupter().isInterruptRequested();
            }
        });
        logger.setLoglevel(0);
        this.script.setLogic(Logics.QF_LIA);
        this.systemsLengthStack.addLast(0);
        this.variablesStack.addLast(0);
    }

    private Term toTerm(Collection<InequalitySystem.Inequality> inequalities) {
        if (inequalities.isEmpty()) {
            return this.script.term("false", new Term[0]);
        }
        Term[] system = new Term[inequalities.size()];
        int nextSystemEntry = 0;
        block3: for (InequalitySystem.Inequality inequality : inequalities) {
            List<BigInteger> coefficients = inequality.getCoefficients();
            Term[] terms = new Term[coefficients.size()];
            int nextEntry = 0;
            for (int i = 0; i < coefficients.size(); ++i) {
                BigInteger coeff = coefficients.get(i);
                if (coeff.equals(BigInteger.ZERO)) continue;
                terms[nextEntry++] = coeff.equals(BigInteger.ONE) ? this.script.term("var" + i, new Term[0]) : this.script.term("*", this.script.numeral(coeff), this.script.term("var" + i, new Term[0]));
            }
            Term rhs = nextEntry == 0 ? this.script.numeral(BigInteger.ZERO) : (nextEntry == 1 ? terms[0] : this.script.term("+", Arrays.copyOf(terms, nextEntry)));
            Term lhs = this.script.numeral(inequality.getLeftHandSide());
            switch (inequality.getComparator()) {
                case UNEQUAL: {
                    system[nextSystemEntry++] = this.script.term("not", this.script.term("=", lhs, rhs));
                    continue block3;
                }
            }
            String comparator = inequality.getComparator().toString();
            system[nextSystemEntry++] = this.script.term(comparator, lhs, rhs);
        }
        if (nextSystemEntry == 1) {
            return system[0];
        }
        return this.script.term("and", system);
    }

    public InequalitySystemSolver assertDisjunction(InequalitySystem ... disjunction) {
        int numVariables = 0;
        for (int i = 0; i < disjunction.length; ++i) {
            numVariables = Math.max(numVariables, disjunction[i].getNumberOfVariables());
        }
        this.systems.add(disjunction);
        int existingVariables = this.variablesStack.pollLast();
        Sort sort = this.script.sort("Int", new Sort[0]);
        for (int i = existingVariables; i < numVariables; ++i) {
            this.script.declareFun("var" + i, new Sort[0], sort);
        }
        this.variablesStack.addLast(Math.max(numVariables, existingVariables));
        Term[] orTerms = new Term[disjunction.length];
        for (int i = 0; i < disjunction.length; ++i) {
            orTerms[i] = this.toTerm(disjunction[i]);
        }
        if (orTerms.length == 1) {
            this.script.assertTerm(orTerms[0]);
        } else if (orTerms.length > 1) {
            this.script.assertTerm(this.script.term("or", orTerms));
        }
        return this;
    }

    public InequalitySystemSolver push() {
        this.script.push(1);
        this.systemsLengthStack.addLast(this.systems.size());
        this.variablesStack.addLast(this.variablesStack.peekLast());
        return this;
    }

    public InequalitySystemSolver pop() {
        this.script.pop(1);
        this.systems.subList(this.systemsLengthStack.removeLast(), this.systems.size()).clear();
        this.variablesStack.removeLast();
        return this;
    }

    public List<BigInteger> findSolution() {
        List<BigInteger> solution = InequalitySystemSolver.handleSolution(this.script, this.variablesStack.peekLast());
        if (solution.isEmpty()) {
            DebugUtil.debug("No solution found for:");
            for (InequalitySystem[] disjunction : this.systems) {
                DebugUtil.debug("at least one of:");
                for (int i = 0; i < disjunction.length; ++i) {
                    DebugUtil.debug((Object)disjunction[i]);
                }
            }
        } else {
            DebugUtil.debug("Solution:");
            DebugUtil.debug(solution);
            assert (this.isSolution(solution)) : solution + " should solve this system but does not";
        }
        return Collections.unmodifiableList(solution);
    }

    private boolean isSolution(List<BigInteger> solution) {
        int index = 0;
        for (InequalitySystem[] disjunction : this.systems) {
            boolean foundSolution = false;
            for (int i = 0; i < disjunction.length && !(foundSolution = disjunction[i].fulfilledBy(solution)); ++i) {
            }
            if (!foundSolution && disjunction.length > 0) {
                DebugUtil.debug((Object)"Not a valid solution for sub-system with index ", (Object)index);
                return false;
            }
            ++index;
        }
        return true;
    }

    private static List<BigInteger> handleSolution(Script script, int numVariables) {
        Script.LBool isSat = script.checkSat();
        if (isSat == Script.LBool.UNKNOWN) {
            assert (ReasonUnknown.CANCELLED.equals(script.getInfo(":reason-unknown"))) : script.getInfo(":reason-unknown");
            throw new UncheckedInterruptedException();
        }
        if (isSat == Script.LBool.UNSAT) {
            DebugUtil.debug((Object)"SMTInterpol produced unsat: ", (Object)isSat);
            return Collections.emptyList();
        }
        Model model = script.getModel();
        ArrayList<BigInteger> solution = new ArrayList<BigInteger>(numVariables);
        for (int i = 0; i < numVariables; ++i) {
            Term term = model.evaluate(script.term("var" + i, new Term[0]));
            assert (term instanceof ConstantTerm) : term;
            Object value = ((ConstantTerm)term).getValue();
            assert (value instanceof Rational) : value;
            Rational rat = (Rational)value;
            solution.add(rat.numerator());
            assert (rat.denominator().equals(BigInteger.ONE)) : value;
        }
        return solution;
    }
}

