/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util.equations;

import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.iterators.UnmodifiableIterator;

public class InequalitySystem
extends AbstractCollection<Inequality> {
    private final List<Inequality> inequalities = new ArrayList<Inequality>();

    private static List<BigInteger> toBigIntegerList(int ... array) {
        ArrayList<BigInteger> result = new ArrayList<BigInteger>(array.length);
        for (int value : array) {
            result.add(BigInteger.valueOf(value));
        }
        return result;
    }

    public int getNumberOfVariables() {
        int numVariables = 0;
        for (Inequality inequality : this.inequalities) {
            if (inequality.getNumberOfCoefficients() <= numVariables) continue;
            numVariables = inequality.getNumberOfCoefficients();
        }
        return numVariables;
    }

    public void addInequality(Inequality inequality) {
        this.inequalities.add(inequality);
    }

    public void addInequality(int lhs, Comparator comparator, int[] coefficients, String comment) {
        this.addInequality(new Inequality(BigInteger.valueOf(lhs), comparator, InequalitySystem.toBigIntegerList(coefficients), comment));
    }

    public void addInequality(int lhs, Comparator comparator, int ... coefficients) {
        this.addInequality(new Inequality(BigInteger.valueOf(lhs), comparator, InequalitySystem.toBigIntegerList(coefficients)));
    }

    public void addInequality(int lhs, String comparator, int[] coefficients, String comment) {
        this.addInequality(lhs, Comparator.fromString(comparator), coefficients, comment);
    }

    public void addInequality(int lhs, String comparator, int ... coefficients) {
        this.addInequality(lhs, Comparator.fromString(comparator), coefficients);
    }

    public void addInequality(int lhs, Comparator comparator, Collection<BigInteger> coefficients, String comment) {
        this.addInequality(new Inequality(BigInteger.valueOf(lhs), comparator, new ArrayList<BigInteger>(coefficients), comment));
    }

    public void addInequality(int lhs, Comparator comparator, Collection<BigInteger> coefficients) {
        this.addInequality(new Inequality(BigInteger.valueOf(lhs), comparator, new ArrayList<BigInteger>(coefficients)));
    }

    public void addInequality(int lhs, String comparator, Collection<BigInteger> coefficients, String comment) {
        this.addInequality(lhs, Comparator.fromString(comparator), coefficients, comment);
    }

    public void addInequality(int lhs, String comparator, Collection<BigInteger> coefficients) {
        this.addInequality(lhs, Comparator.fromString(comparator), coefficients);
    }

    public boolean fulfilledBy(List<? extends Number> values) {
        for (Inequality inequality : this.inequalities) {
            if (inequality.fulfilledBy(values)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.inequalities.size();
    }

    @Override
    public Iterator<Inequality> iterator() {
        return UnmodifiableIterator.unmodifiableIterator(this.inequalities.iterator());
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[\n");
        for (Inequality inequality : this.inequalities) {
            buffer.append(inequality.toString());
            buffer.append("\n");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static class Inequality {
        private final BigInteger leftHandSide;
        private final Comparator comparator;
        private final List<BigInteger> coefficients;
        private final String comment;

        public Inequality(BigInteger leftHandSide, Comparator comparator, List<BigInteger> coefficients, String comment) {
            this.leftHandSide = leftHandSide;
            this.comparator = comparator;
            this.coefficients = Collections.unmodifiableList(coefficients);
            this.comment = comment;
        }

        public Inequality(BigInteger leftHandSide, Comparator comparator, List<BigInteger> coefficients) {
            this(leftHandSide, comparator, coefficients, "");
        }

        public String getComment() {
            return this.comment;
        }

        public BigInteger getLeftHandSide() {
            return this.leftHandSide;
        }

        public Comparator getComparator() {
            return this.comparator;
        }

        public List<BigInteger> getCoefficients() {
            return this.coefficients;
        }

        public int getNumberOfCoefficients() {
            return this.coefficients.size();
        }

        public boolean fulfilledBy(List<? extends Number> values) {
            BigInteger rhs = BigInteger.ZERO;
            for (int i = 0; i < this.coefficients.size(); ++i) {
                BigInteger value;
                Number numberValue = values.get(i);
                if (numberValue instanceof Integer) {
                    value = BigInteger.valueOf(((Integer)numberValue).intValue());
                } else if (numberValue instanceof BigInteger) {
                    value = (BigInteger)numberValue;
                } else {
                    throw new AssertionError((Object)"Sorry, cannot handle this type of list");
                }
                BigInteger coeff = this.coefficients.get(i);
                rhs = rhs.add(coeff.multiply(value));
            }
            return this.comparator.compare(this.leftHandSide, rhs);
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.leftHandSide).append(' ');
            buffer.append(this.comparator.toString()).append(' ');
            boolean first = true;
            for (int j = 0; j < this.coefficients.size(); ++j) {
                BigInteger c = this.coefficients.get(j);
                if (c.equals(BigInteger.ZERO)) continue;
                if (!first) {
                    buffer.append(" + ");
                }
                buffer.append(c);
                buffer.append("*x[");
                buffer.append(j);
                buffer.append("]");
                first = false;
            }
            if (first) {
                buffer.append("0");
            }
            if (!this.comment.isEmpty()) {
                buffer.append("\t(");
                buffer.append(this.comment);
                buffer.append(")");
            }
            return buffer.toString();
        }
    }

    public static enum Comparator {
        LESS_THAN_OR_EQUAL("<="),
        LESS_THAN("<"),
        EQUAL("="),
        UNEQUAL("!="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">=");

        private final String representation;

        private Comparator(String representation) {
            this.representation = representation;
        }

        public String toString() {
            return this.representation;
        }

        public <T> boolean compare(Comparable<T> left, T right) {
            int result = left.compareTo(right);
            switch (this) {
                case LESS_THAN_OR_EQUAL: {
                    return result <= 0;
                }
                case LESS_THAN: {
                    return result < 0;
                }
                case EQUAL: {
                    return result == 0;
                }
                case UNEQUAL: {
                    return result != 0;
                }
                case GREATER_THAN: {
                    return result > 0;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return result >= 0;
                }
            }
            throw new AssertionError((Object)("Came across a Comparator with an invalid value: " + this.toString()));
        }

        public static Comparator fromString(String str) {
            for (Comparator comp : Comparator.values()) {
                if (!comp.toString().equals(str)) continue;
                return comp;
            }
            throw new AssertionError((Object)("Unknown Comparator '" + str + "'"));
        }
    }
}

