/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util.equations;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uniol.apt.util.DebugUtil;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class EquationSystem {
    private final int numVariables;
    private final Collection<List<BigInteger>> equations = new HashSet<List<BigInteger>>();

    public EquationSystem(int numVariables) {
        assert (numVariables >= 0);
        this.numVariables = numVariables;
    }

    public void addEquation(int ... coefficients) {
        assert (coefficients.length == this.numVariables);
        ArrayList<BigInteger> row = new ArrayList<BigInteger>(this.numVariables);
        for (int i = 0; i < coefficients.length; ++i) {
            row.add(BigInteger.valueOf(coefficients[i]));
        }
        this.equations.add(row);
    }

    public void addEquation(Collection<BigInteger> coefficients) {
        assert (coefficients.size() == this.numVariables);
        ArrayList<BigInteger> row = new ArrayList<BigInteger>(coefficients);
        this.equations.add(row);
    }

    public Set<List<BigInteger>> findBasis() {
        HashSet result = new HashSet();
        EquationSystemSolver solver = new EquationSystemSolver(this.numVariables, this.equations);
        List<List<BigInteger>> solution = solver.solve();
        assert (solution.size() == this.numVariables);
        for (int i = 0; i < this.numVariables; ++i) {
            boolean allZero = true;
            ArrayList<BigInteger> row = new ArrayList<BigInteger>(this.numVariables);
            for (int j = 0; j < this.numVariables; ++j) {
                BigInteger value = solution.get(j).get(i);
                if (!value.equals(BigInteger.ZERO)) {
                    allZero = false;
                }
                row.add(value);
            }
            if (allZero) continue;
            result.add(Collections.unmodifiableList(row));
        }
        DebugUtil.debug((Object)"Basis found: ", result);
        DebugUtil.debug("");
        return Collections.unmodifiableSet(result);
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        buffer.write("[\n");
        for (List<BigInteger> equation : this.equations) {
            boolean first = true;
            for (int j = 0; j < this.numVariables; ++j) {
                if (equation.get(j).equals(BigInteger.ZERO)) continue;
                if (!first) {
                    buffer.write(" + ");
                }
                buffer.write("" + equation.get(j));
                buffer.write("*x[");
                buffer.write("" + j);
                buffer.write("]");
                first = false;
            }
            if (first) {
                buffer.write("0");
            }
            buffer.write(" = 0\n");
        }
        buffer.write("]");
        return buffer.toString();
    }

    private static class EquationSystemSolver {
        private final List<List<BigInteger>> equations1 = new ArrayList<List<BigInteger>>();
        private final List<List<BigInteger>> equations2 = new ArrayList<List<BigInteger>>();
        private final int numVariables;

        EquationSystemSolver(int numVariables, Collection<List<BigInteger>> equations) {
            this.numVariables = numVariables;
            this.equations2.addAll(equations);
            for (int i = 0; i < numVariables; ++i) {
                ArrayList<BigInteger> equation = new ArrayList<BigInteger>(numVariables);
                for (int j = 0; j < numVariables; ++j) {
                    equation.add(j == i ? BigInteger.ONE : BigInteger.ZERO);
                }
                this.equations1.add(equation);
            }
        }

        public List<List<BigInteger>> solve() {
            DebugUtil.debug("solve called");
            DebugUtil.debug("============");
            while (!this.equations2.isEmpty()) {
                boolean restart;
                InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                DebugUtil.debug("New round");
                DebugUtil.debug(this.equations1);
                DebugUtil.debug(this.equations2);
                DebugUtil.debug();
                List<BigInteger> equation = this.equations2.get(0);
                for (int i = 0; i < this.numVariables; ++i) {
                    if (equation.get(i).compareTo(BigInteger.ZERO) >= 0) continue;
                    this.invertVariableY(i);
                }
                block2: do {
                    InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
                    restart = false;
                    for (int i = 0; i < this.numVariables; ++i) {
                        BigInteger lambdai = equation.get(i);
                        if (lambdai.equals(BigInteger.ZERO)) continue;
                        for (int j = i + 1; j < this.numVariables; ++j) {
                            BigInteger lambdaj = equation.get(j);
                            if (lambdaj.equals(BigInteger.ZERO)) continue;
                            if (lambdaj.compareTo(lambdai) < 0) {
                                int tmp1 = i;
                                i = j;
                                j = tmp1;
                                BigInteger tmp2 = lambdai;
                                lambdai = lambdaj;
                                lambdaj = tmp2;
                            }
                            BigDecimal a = new BigDecimal(lambdaj);
                            BigDecimal b = new BigDecimal(lambdai);
                            BigDecimal result = a.divide(b, RoundingMode.FLOOR);
                            this.substituteVariable(j, result.toBigIntegerExact().negate(), i);
                            restart = true;
                            break;
                        }
                        if (restart) continue block2;
                    }
                } while (restart);
                DebugUtil.debug(this.equations1);
                DebugUtil.debug(this.equations2);
                DebugUtil.debug();
                this.removeRedundancy();
            }
            DebugUtil.debug("Result:");
            DebugUtil.debug(this.equations1);
            return Collections.unmodifiableList(this.equations1);
        }

        private void removeRedundancy() {
            int j;
            int i;
            for (i = 0; i < this.equations2.size(); ++i) {
                Integer nonZeroIndex = null;
                List<BigInteger> equation = this.equations2.get(i);
                for (j = 0; j < this.numVariables; ++j) {
                    if (equation.get(j).equals(BigInteger.ZERO)) continue;
                    if (nonZeroIndex == null) {
                        nonZeroIndex = j;
                        continue;
                    }
                    nonZeroIndex = null;
                    break;
                }
                if (nonZeroIndex == null) continue;
                this.equations2.remove(i--);
                this.removeVariable(nonZeroIndex);
            }
            for (i = 0; i < this.equations2.size(); ++i) {
                List<BigInteger> equation = this.equations2.get(i);
                boolean found = false;
                for (j = 0; j < this.numVariables; ++j) {
                    if (equation.get(j).equals(BigInteger.ZERO)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.equations2.remove(i--);
            }
        }

        private void invertVariableY(int j) {
            List<BigInteger> equation;
            int i;
            DebugUtil.debugFormat("Inverting variable y_%d", j);
            for (i = 0; i < this.equations1.size(); ++i) {
                equation = this.equations1.get(i);
                equation.set(j, equation.get(j).negate());
            }
            for (i = 0; i < this.equations2.size(); ++i) {
                equation = this.equations2.get(i);
                equation.set(j, equation.get(j).negate());
            }
        }

        private void removeVariable(int j) {
            int i;
            DebugUtil.debugFormat("Removing variable y_%d", j);
            for (i = 0; i < this.equations1.size(); ++i) {
                this.equations1.get(i).set(j, BigInteger.ZERO);
            }
            for (i = 0; i < this.equations2.size(); ++i) {
                this.equations2.get(i).set(j, BigInteger.ZERO);
            }
        }

        private void substituteVariable(int variableIndex, BigInteger factor, int addendIndex) {
            int i;
            DebugUtil.debugFormat("Substituting variable y_%d with y_%d + %d * y_%d", variableIndex, variableIndex, factor, addendIndex);
            for (i = 0; i < this.equations1.size(); ++i) {
                EquationSystemSolver.substituteVariable(this.equations1.get(i), variableIndex, factor, addendIndex);
            }
            for (i = 0; i < this.equations2.size(); ++i) {
                EquationSystemSolver.substituteVariable(this.equations2.get(i), variableIndex, factor, addendIndex);
            }
        }

        private static void substituteVariable(List<BigInteger> equation, int variableIndex, BigInteger factor, int addendIndex) {
            BigInteger addend = equation.get(addendIndex);
            BigInteger variableValue = equation.get(variableIndex);
            BigInteger newValue = variableValue.add(factor.multiply(addend));
            equation.set(variableIndex, newValue);
        }
    }
}

