/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uniol.apt.adt.IEdge;
import uniol.apt.adt.IGraph;
import uniol.apt.adt.INode;
import uniol.apt.adt.StructuralExtensionRemover;
import uniol.apt.adt.exception.StructureException;
import uniol.apt.adt.extension.ExtensionProperty;
import uniol.apt.util.interrupt.InterrupterRegistry;

public class SpanningTree<G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> {
    private final boolean forwardDirection;
    private final Map<N, E> predecessorMap;
    private final Set<N> unreachableNodes;
    private final Set<E> chords;
    private final N startNode;
    private final G graph;

    public static <G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> SpanningTree<G, E, N> get(G graph) {
        return SpanningTree.get(graph, graph.getNodes().isEmpty() ? null : (INode)graph.getNodes().iterator().next());
    }

    public static <G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> SpanningTree<G, E, N> getReversed(G graph) {
        return SpanningTree.getReversed(graph, graph.getNodes().isEmpty() ? null : (INode)graph.getNodes().iterator().next());
    }

    public static <G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> SpanningTree<G, E, N> get(G graph, N startNode) {
        return SpanningTree.get(graph, startNode, true);
    }

    public static <G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> SpanningTree<G, E, N> getReversed(G graph, N startNode) {
        return SpanningTree.get(graph, startNode, false);
    }

    private static <G extends IGraph<G, E, N>, E extends IEdge<G, E, N>, N extends INode<G, E, N>> SpanningTree<G, E, N> get(G graph, N startNode, boolean forwardDirection) {
        String key = SpanningTree.class.getName();
        if (!forwardDirection) {
            key = key + "-backwards";
        }
        Object extension = null;
        try {
            extension = graph.getExtension(key);
        }
        catch (StructureException structureException) {
            // empty catch block
        }
        Map<N, SpanningTree<G, E, N>> map = null;
        if (extension != null && extension instanceof Map) {
            Map castedMap = (Map)extension;
            map = castedMap;
        } else {
            map = new HashMap();
            graph.putExtension(key, map, ExtensionProperty.NOCOPY);
            graph.addListener(new StructuralExtensionRemover(key));
        }
        Object tree = map.get(startNode);
        if (tree != null && tree instanceof SpanningTree) {
            SpanningTree result = (SpanningTree)tree;
            return result;
        }
        SpanningTree<G, E, N> result = new SpanningTree<G, E, N>(graph, startNode, forwardDirection);
        map.put(startNode, result);
        return result;
    }

    private SpanningTree(G graph, N startNode, boolean forwardDirection) {
        HashMap predecessorMap = new HashMap();
        HashSet unvisitedNodes = new HashSet(graph.getNodes());
        LinkedList stillToVisit = new LinkedList();
        HashSet<IEdge> chords = new HashSet<IEdge>();
        if (startNode != null) {
            unvisitedNodes.remove(startNode);
        }
        Object node = startNode;
        while (node != null) {
            InterrupterRegistry.throwIfInterruptRequestedForCurrentThread();
            for (IEdge edge : forwardDirection ? node.getPostsetEdges() : node.getPresetEdges()) {
                Object child = forwardDirection ? edge.getTarget() : edge.getSource();
                if (unvisitedNodes.remove(child)) {
                    predecessorMap.put(child, edge);
                    stillToVisit.addLast(child);
                    continue;
                }
                chords.add(edge);
            }
            node = (INode)stillToVisit.pollFirst();
        }
        this.forwardDirection = forwardDirection;
        this.predecessorMap = Collections.unmodifiableMap(predecessorMap);
        this.unreachableNodes = Collections.unmodifiableSet(unvisitedNodes);
        this.chords = Collections.unmodifiableSet(chords);
        this.startNode = startNode;
        this.graph = graph;
    }

    public boolean isReachable(N node) {
        return !this.unreachableNodes.contains(node);
    }

    public boolean isTotallyReachable() {
        return this.unreachableNodes.isEmpty();
    }

    public Set<N> getUnreachableNodes() {
        return this.unreachableNodes;
    }

    public N getPredecessor(N node) {
        E e = this.getPredecessorEdge(node);
        if (e != null) {
            if (this.forwardDirection) {
                return e.getSource();
            }
            return e.getTarget();
        }
        return null;
    }

    public E getPredecessorEdge(N node) {
        return (E)((IEdge)this.predecessorMap.get(node));
    }

    public List<E> getEdgePathFromStart(N node) {
        if (!this.predecessorMap.containsKey(node) && !node.equals(this.startNode)) {
            return Collections.emptyList();
        }
        ArrayList<E> result = new ArrayList<E>();
        while (node != null) {
            if (this.predecessorMap.containsKey(node)) {
                result.add(this.predecessorMap.get(node));
            }
            node = this.getPredecessor(node);
        }
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    public List<N> getNodePathFromStart(N node) {
        if (!this.predecessorMap.containsKey(node) && !node.equals(this.startNode)) {
            return Collections.emptyList();
        }
        ArrayList<N> result = new ArrayList<N>();
        while (node != null) {
            result.add(node);
            node = this.getPredecessor(node);
        }
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    public Set<E> getChords() {
        return this.chords;
    }

    public N getStartNode() {
        return this.startNode;
    }

    public G getGraph() {
        return this.graph;
    }
}

