/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PowerSet<E>
extends AbstractCollection<Collection<E>> {
    private final List<E> c;

    public PowerSet(Collection<E> c) {
        this.c = c instanceof List ? (List)c : new ArrayList<E>(c);
    }

    @Override
    public int size() {
        return (int)Math.pow(2.0, this.c.size());
    }

    @Override
    public Iterator<Collection<E>> iterator() {
        return new PowerSetIterator<E>(this.c);
    }

    public static <E> PowerSet<E> powerSet(Collection<E> c) {
        return new PowerSet<E>(c);
    }

    public static class BitSetIterator
    implements Iterator<BitSet> {
        private final int size;
        private BitSet state;

        public BitSetIterator(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("Size may not be negative, got " + size);
            }
            this.size = size;
            this.state = new BitSet(size);
        }

        @Override
        public boolean hasNext() {
            return this.state != null;
        }

        @Override
        public BitSet next() {
            BitSet result = this.state.get(0, this.size);
            int lastClear = this.state.previousClearBit(this.size - 1);
            if (lastClear >= 0) {
                this.state.flip(lastClear, this.size);
            } else {
                this.state = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class BitSetIterable
    extends AbstractCollection<BitSet> {
        private final int size;

        public BitSetIterable(int size) {
            this.size = size;
        }

        @Override
        public int size() {
            return (int)Math.pow(2.0, this.size);
        }

        @Override
        public Iterator<BitSet> iterator() {
            return new BitSetIterator(this.size);
        }
    }

    public static class PowerSetIterator<E>
    implements Iterator<Collection<E>> {
        private final List<E> c;
        private final Iterator<BitSet> iter;

        public PowerSetIterator(List<E> c) {
            this.c = c;
            this.iter = new BitSetIterator(c.size());
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Collection<E> next() {
            BitSet next = this.iter.next();
            ArrayList<E> result = new ArrayList<E>(next.cardinality());
            int i = 0;
            for (E e : this.c) {
                if (!next.get(i++)) continue;
                result.add(e);
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

