/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Pair<X, Y> {
    private final X q1;
    private final Y q2;

    public Pair(X q1, Y q2) {
        this.q1 = q1;
        this.q2 = q2;
    }

    public X getFirst() {
        return this.q1;
    }

    public Y getSecond() {
        return this.q2;
    }

    public String toString() {
        return "(" + this.q1 + "," + this.q2 + ")";
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Pair)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        Pair otherPair = (Pair)other;
        return Objects.equals(this.q1, otherPair.q1) && Objects.equals(this.q2, otherPair.q2);
    }

    public int hashCode() {
        return Objects.hash(this.q1, this.q2);
    }

    public static <X, Y> List<Pair<X, Y>> zip(Collection<X> col1, Collection<Y> col2) {
        if (col1.size() != col2.size()) {
            throw new IllegalArgumentException("Collection need equal sizes");
        }
        ArrayList<Pair<X, Y>> ret = new ArrayList<Pair<X, Y>>();
        Iterator<Y> it = col2.iterator();
        for (X ele1 : col1) {
            assert (it.hasNext());
            Y ele2 = it.next();
            ret.add(new Pair<X, Y>(ele1, ele2));
        }
        return ret;
    }

    public static <X, Y> Pair<List<X>, List<Y>> unzip(Iterable<Pair<X, Y>> iterable) {
        ArrayList<X> ret1 = new ArrayList<X>();
        ArrayList<Y> ret2 = new ArrayList<Y>();
        for (Pair<X, Y> ele : iterable) {
            ret1.add(ele.getFirst());
            ret2.add(ele.getSecond());
        }
        return new Pair<List<X>, List<Y>>(ret1, ret2);
    }
}

