/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;

public class MathTools {
    private MathTools() {
    }

    public static int gcd(Collection<Integer> set) {
        if (set.isEmpty()) {
            return 0;
        }
        Iterator<Integer> iter = set.iterator();
        int gcd = iter.next();
        while (iter.hasNext()) {
            if ((gcd = MathTools.gcd(gcd, (int)iter.next())) != 1) continue;
            return 1;
        }
        return gcd;
    }

    public static int gcd(int ... set) {
        if (set.length == 0) {
            return 0;
        }
        int gcd = Math.abs(set[0]);
        for (int i = 1; i < set.length; ++i) {
            gcd = MathTools.gcd(gcd, set[i]);
        }
        return gcd;
    }

    public static int gcd(int a, int b) {
        a = Math.abs(a);
        b = Math.abs(b);
        while (a != 0) {
            int tmp = a;
            a = b % a;
            b = tmp;
        }
        return b;
    }

    public static BigInteger lcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b).abs();
    }

    public static int lcm(int a, int b) {
        return MathTools.bigIntToInt(MathTools.lcm(BigInteger.valueOf(a), BigInteger.valueOf(b)));
    }

    private static int bigIntToInt(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0 || value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Cannot represent value as int: " + value);
        }
        return value.intValue();
    }

    public static int mod(int a, int b) {
        return BigInteger.valueOf(a).mod(BigInteger.valueOf(b)).intValue();
    }

    public static int meanTowardsMinusInfinity(int x, int y) {
        return ((x ^ y) >> 1) + (x & y);
    }
}

