/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import uniol.apt.util.AbstractEquivalenceRelation;
import uniol.apt.util.IEquivalenceRelation;

public class DomainEquivalenceRelation<E>
extends AbstractEquivalenceRelation<E> {
    private final Set<E> domain;

    public DomainEquivalenceRelation(Collection<E> domain) {
        this.domain = new HashSet<E>(domain);
        for (E e : this.domain) {
            this.getClass(e);
        }
    }

    @Override
    protected void checkValidElement(E e) {
        if (!this.domain.contains(e)) {
            throw new IllegalArgumentException(e + " is not in the domain of this relation");
        }
    }

    @Override
    public DomainEquivalenceRelation<E> refine(IEquivalenceRelation<? super E> relation) {
        DomainEquivalenceRelation<E> result = new DomainEquivalenceRelation<E>(this.domain);
        if (super.refine(result, relation)) {
            return result;
        }
        return this;
    }

    @Override
    public Iterator<Set<E>> iterator() {
        return new Iterator<Set<E>>(){
            private Iterator<Set<E>> iter;
            {
                this.iter = DomainEquivalenceRelation.this.leaderToClass.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Set<E> next() {
                return Collections.unmodifiableSet(this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

