/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.EmptyIterator;
import uniol.apt.util.Pair;

public class DifferentPairsIterable<E>
implements Iterable<Pair<E, E>> {
    private final Collection<E> collection;

    public DifferentPairsIterable(Collection<E> collection) {
        this.collection = collection;
    }

    @Override
    public Iterator<Pair<E, E>> iterator() {
        return new Iterator<Pair<E, E>>(){
            private Deque<E> remainingElements;
            private Iterator<E> iter;
            private E currentElement;
            {
                this.remainingElements = new ArrayDeque(DifferentPairsIterable.this.collection);
                this.iter = EmptyIterator.emptyIterator();
                this.currentElement = null;
            }

            @Override
            public boolean hasNext() {
                while (!this.iter.hasNext()) {
                    if (this.remainingElements.isEmpty()) {
                        return false;
                    }
                    this.currentElement = this.remainingElements.remove();
                    this.iter = this.remainingElements.iterator();
                }
                return true;
            }

            @Override
            public Pair<E, E> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new Pair(this.currentElement, this.iter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

