/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public final class DebugUtil {
    public static final boolean OUTPUT_ENABLED = Boolean.getBoolean("apt.debug");
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
    };

    private DebugUtil() {
    }

    private static void printDebug(String prefix, String message) {
        prefix = DATE_FORMAT.get().format(new Date()) + " " + prefix + ": ";
        for (String line : message.split("\n")) {
            System.err.println(prefix + line);
        }
    }

    private static String getCaller() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length < 3) {
            return "unknown";
        }
        String klass = trace[3].getClassName();
        int index = klass.lastIndexOf(".");
        if (index < 0) {
            return klass;
        }
        return klass.substring(index + 1);
    }

    public static void debugFormat(String format, Object ... args) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), String.format(format, args));
        }
    }

    public static void debug(String message) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), message);
        }
    }

    public static void debug() {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), "");
        }
    }

    public static void debug(Object obj) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), Objects.toString(obj));
        }
    }

    public static void debug(Object obj1, Object obj2) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), Objects.toString(obj1) + Objects.toString(obj2));
        }
    }

    public static void debug(Object obj1, Object obj2, Object obj3) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), Objects.toString(obj1) + Objects.toString(obj2) + Objects.toString(obj3));
        }
    }

    public static void debug(Object obj1, Object obj2, Object obj3, Object obj4) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), Objects.toString(obj1) + Objects.toString(obj2) + Objects.toString(obj3) + Objects.toString(obj4));
        }
    }

    public static void debug(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), Objects.toString(obj1) + Objects.toString(obj2) + Objects.toString(obj3) + Objects.toString(obj4) + Objects.toString(obj5));
        }
    }

    public static void debug(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), Objects.toString(obj1) + Objects.toString(obj2) + Objects.toString(obj3) + Objects.toString(obj4) + Objects.toString(obj5) + Objects.toString(obj6));
        }
    }

    public static void debug(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), Objects.toString(obj1) + Objects.toString(obj2) + Objects.toString(obj3) + Objects.toString(obj4) + Objects.toString(obj5) + Objects.toString(obj6) + Objects.toString(obj7));
        }
    }

    public static void debug(Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8) {
        if (OUTPUT_ENABLED) {
            DebugUtil.printDebug(DebugUtil.getCaller(), Objects.toString(obj1) + Objects.toString(obj2) + Objects.toString(obj3) + Objects.toString(obj4) + Objects.toString(obj5) + Objects.toString(obj6) + Objects.toString(obj7) + Objects.toString(obj8));
        }
    }

    public static void debug(Object ... objs) {
        if (OUTPUT_ENABLED) {
            StringBuilder sb = new StringBuilder();
            for (Object o : objs) {
                sb.append(Objects.toString(o));
            }
            DebugUtil.printDebug(DebugUtil.getCaller(), sb.toString());
        }
    }
}

