/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import uniol.apt.util.IEquivalenceRelation;

public abstract class AbstractEquivalenceRelation<E>
extends AbstractCollection<Set<E>>
implements Collection<Set<E>>,
IEquivalenceRelation<E> {
    private final Map<E, E> elementToParent = new HashMap<E, E>();
    protected final Map<E, Set<E>> leaderToClass = new HashMap<E, Set<E>>();

    public abstract AbstractEquivalenceRelation<E> refine(IEquivalenceRelation<? super E> var1);

    protected void checkValidElement(E e) {
    }

    protected boolean refine(AbstractEquivalenceRelation<? super E> newRelation, IEquivalenceRelation<? super E> relation) {
        boolean hadSplit = false;
        for (Set<E> klass : this) {
            HashSet<E> unhandled = new HashSet<E>(klass);
            while (!unhandled.isEmpty()) {
                Iterator it = unhandled.iterator();
                Object e1 = it.next();
                it.remove();
                while (it.hasNext()) {
                    Object e2 = it.next();
                    if (relation.isEquivalent(e1, e2)) {
                        it.remove();
                        newRelation.joinClasses(e1, e2);
                        continue;
                    }
                    hadSplit = true;
                }
            }
        }
        return hadSplit;
    }

    public Set<E> joinClasses(E e1, E e2) {
        e1 = this.getLeader(e1);
        e2 = this.getLeader(e2);
        Set<E> class1 = this.getClass(e1);
        Set<E> class2 = this.getClass(e2);
        if (class1.contains(e2)) {
            return class1;
        }
        if (class1.size() > class2.size()) {
            Set<E> classTmp = class1;
            class1 = class2;
            class2 = classTmp;
            E eTmp = e1;
            e1 = e2;
            e2 = eTmp;
        }
        class2.addAll(class1);
        this.leaderToClass.remove(e1);
        this.elementToParent.put(e1, e2);
        return class2;
    }

    private E getLeader(E e) {
        this.checkValidElement(e);
        E parent = e;
        E next = this.elementToParent.get(parent);
        while (next != null) {
            parent = next;
            next = this.elementToParent.get(parent);
        }
        if (e != parent) {
            this.elementToParent.put(e, parent);
        }
        return parent;
    }

    private Set<E> getClassIfExists(E e) {
        return this.leaderToClass.get(this.getLeader(e));
    }

    public Set<E> getClass(E e) {
        Set<E> result = this.getClassIfExists(e);
        if (result == null) {
            result = new HashSet();
            result.add(e);
            this.leaderToClass.put(e, result);
        }
        return result;
    }

    @Override
    public boolean isEquivalent(E e1, E e2) {
        if (e1.equals(e2)) {
            return true;
        }
        Set<E> klass = this.getClassIfExists(e1);
        return klass != null && klass.contains(e2);
    }

    @Override
    public int size() {
        return this.leaderToClass.size();
    }

    @Override
    public abstract Iterator<Set<E>> iterator();

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEquivalenceRelation)) {
            return false;
        }
        AbstractEquivalenceRelation rel = (AbstractEquivalenceRelation)o;
        if (rel.size() != this.size()) {
            return false;
        }
        return this.containsAll(rel);
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Set<E> set : this) {
            result += set.hashCode();
        }
        return result;
    }
}

