/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl.returns;

import java.io.IOException;
import java.io.Writer;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.ui.AptReturnValueTransformation;
import uniol.apt.ui.ReturnValueTransformation;

@AptReturnValueTransformation(value={Marking.class})
public class MarkingReturnValueTransformation
implements ReturnValueTransformation<Marking> {
    @Override
    public void transform(Writer output, Marking m) throws IOException {
        PetriNet pn = m.getNet();
        for (Place p : pn.getPlaces()) {
            Token v = m.getToken(p);
            if (v.getValue() <= 0L && !v.isOmega()) continue;
            output.append(p.getId()).append(":");
            if (v.isOmega()) {
                output.append("OMEGA");
            } else {
                output.append(Long.toString(v.getValue()));
            }
            output.append(" ");
        }
    }
}

