/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl.returns;

import java.io.IOException;
import java.io.Writer;
import uniol.apt.io.renderer.RendererNotFoundException;
import uniol.apt.io.renderer.Renderers;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.ui.ReturnValueTransformationWithOptions;

public abstract class AbstractRenderersReturnValueTransformation<T>
implements ReturnValueTransformationWithOptions<T> {
    private final Renderers<T> renderers;
    private final String defaultRenderer;

    public AbstractRenderersReturnValueTransformation(Renderers<T> renderers, String defaultRenderer) {
        this.renderers = renderers;
        this.defaultRenderer = defaultRenderer;
    }

    @Override
    public void transform(Writer output, T arg) throws ModuleException, IOException {
        this.transform(output, arg, this.defaultRenderer);
    }

    @Override
    public void transform(Writer output, T arg, String renderer) throws ModuleException, IOException {
        try {
            this.renderers.getRenderer(renderer).render(arg, output);
        }
        catch (RendererNotFoundException ex) {
            StringBuilder message = new StringBuilder();
            message.append(ex.getMessage());
            message.append("\nSupported file formats:");
            for (String name : this.renderers.getSupportedFormats()) {
                message.append(' ').append(name);
            }
            throw new RendererNotFoundException(message.toString(), ex);
        }
    }
}

