/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl.parameter;

import java.util.Arrays;
import uniol.apt.analysis.language.Word;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.ui.AptParameterTransformation;
import uniol.apt.ui.DescribedParameterTransformation;

@AptParameterTransformation(value={Word.class})
public class WordParameterTransformation
implements DescribedParameterTransformation<Word> {
    public static final String SIGN_FOR_SINGLE_CHARACTERS = ":";

    @Override
    public Word transform(String arg) throws ModuleException {
        String[] tokens;
        if (arg.startsWith(SIGN_FOR_SINGLE_CHARACTERS) && arg.endsWith(SIGN_FOR_SINGLE_CHARACTERS)) {
            tokens = (arg = arg.substring(SIGN_FOR_SINGLE_CHARACTERS.length(), arg.length() - 1)).split("");
            if (tokens.length > 0 && tokens[0].isEmpty()) {
                tokens = Arrays.copyOfRange(tokens, 1, tokens.length);
            }
        } else {
            tokens = arg.contains(";") ? arg.split(";", -1) : (arg.contains(",") ? arg.split(",", -1) : arg.split(" ", -1));
        }
        Word word = new Word();
        for (String t : tokens) {
            if ((t = t.trim()).isEmpty()) {
                throw new ModuleException("Empty label found while parsing word '" + arg + "' after " + word + ".");
            }
            word.add(t);
        }
        return word;
    }

    @Override
    public String getFormatDescription() {
        return "Words can be specified in two different forms.\nThe first format includes explicit delimiters between events. For delimiters, either commas, semicolons or spaces are allowed. An example of this format would be 'a, b, c'. Note that leading and trailing spaces are skipped.\nThe second format expects events to be individual letters. The special prefix : is used to indicate this format. An example would be ':abc'.";
    }
}

