/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl.parameter;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.impl.AptLTSParser;
import uniol.apt.io.parser.impl.AptPNParser;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.ui.AptParameterTransformation;
import uniol.apt.ui.ParameterTransformation;

@AptParameterTransformation(value={PetriNetOrTransitionSystem.class}, fileSource=true)
public class NetOrTSParameterTransformation
implements ParameterTransformation<PetriNetOrTransitionSystem> {
    @Override
    public PetriNetOrTransitionSystem transform(String input) throws ModuleException {
        PetriNet pn = null;
        ParseException pnEx = null;
        TransitionSystem ts = null;
        ParseException tsEx = null;
        try {
            pn = (PetriNet)new AptPNParser().parseString(input);
        }
        catch (ParseException ex) {
            pnEx = ex;
        }
        try {
            ts = (TransitionSystem)new AptLTSParser().parseString(input);
        }
        catch (ParseException ex) {
            tsEx = ex;
        }
        if (pnEx == null && tsEx == null) {
            throw new ModuleException("Parsers can't decide if the input is a Petri net or a transition system.");
        }
        if (pnEx != null && tsEx != null) {
            throw new ModuleException(String.format("Input is neither a Petri net nor a transition system.%nPetri net parser error: %s%nTransition system parser error: %s", pnEx.getMessage(), tsEx.getMessage()));
        }
        if (pn != null) {
            return new PetriNetOrTransitionSystem(pn);
        }
        assert (ts != null);
        return new PetriNetOrTransitionSystem(ts);
    }
}

