/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.ParserNotFoundException;
import uniol.apt.io.parser.Parsers;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.ui.StreamWithOptionsParameterTransformation;

public abstract class AbstractParsersParameterTransformation<G>
extends StreamWithOptionsParameterTransformation<G> {
    private final Parsers<G> parsers;
    private final String defaultParser;
    private final String objectName;

    public AbstractParsersParameterTransformation(Parsers<G> parsers, String defaultParser, String objectName) {
        this.parsers = parsers;
        this.defaultParser = defaultParser;
        this.objectName = objectName;
    }

    @Override
    public G transform(InputStream input, String parser) throws ModuleException, IOException {
        if (parser.isEmpty()) {
            parser = this.defaultParser;
        }
        try {
            return this.parsers.getParser(parser).parse(input);
        }
        catch (ParseException ex) {
            throw new ModuleException("Can't parse " + this.objectName + ": " + ex.getMessage(), ex);
        }
        catch (ParserNotFoundException ex) {
            StringBuilder message = new StringBuilder();
            message.append(ex.getMessage());
            message.append("\nSupported file formats:");
            for (String name : this.parsers.getSupportedFormats()) {
                message.append(' ').append(name);
            }
            throw new ParserNotFoundException(message.toString(), ex);
        }
    }
}

