/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl.parameter;

import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.collections4.Trie;
import org.apache.commons.collections4.trie.PatriciaTrie;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.ui.ParameterTransformation;

public abstract class AbstractMapParameterTransformation<T>
implements ParameterTransformation<T> {
    private final Trie<String, T> map;

    public AbstractMapParameterTransformation(Map<String, T> values) {
        this.map = new PatriciaTrie<T>(values);
    }

    @SafeVarargs
    public AbstractMapParameterTransformation(T ... values) {
        this.map = new PatriciaTrie<T>();
        for (T value : values) {
            T old = this.map.put(value.toString().toLowerCase(), value);
            if (old == null) continue;
            throw new IllegalArgumentException("Duplicate values for " + value.toString() + " and " + old.toString());
        }
    }

    @Override
    public T transform(String arg) throws ModuleException {
        String lowerCaseArg = arg.toLowerCase();
        Object result = this.map.get(lowerCaseArg);
        if (result != null) {
            return (T)result;
        }
        SortedMap<String, T> prefix = this.map.prefixMap(lowerCaseArg);
        if (prefix.size() == 1) {
            return (T)prefix.entrySet().iterator().next().getValue();
        }
        throw new ModuleException(String.format("Unsupported argument '%s'. Valid options are %s.", arg, this.map.keySet()));
    }
}

