/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl;

import java.util.Formatter;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import uniol.apt.module.Module;
import uniol.apt.module.exception.NoSuchTransformationException;
import uniol.apt.module.impl.ModuleUtils;
import uniol.apt.module.impl.OptionalParameter;
import uniol.apt.module.impl.Parameter;
import uniol.apt.module.impl.ReturnValue;
import uniol.apt.ui.ParametersTransformer;

public class UIUtils {
    private UIUtils() {
    }

    public static String getModuleUsage(Module module, ParametersTransformer parametersTransformer) throws NoSuchTransformationException {
        List<Parameter> parameters = ModuleUtils.getParameters(module);
        List<OptionalParameter<?>> optionalParameters = ModuleUtils.getOptionalParameters(module);
        List<ReturnValue> fileReturnValues = ModuleUtils.getFileReturnValues(module);
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("Usage: apt %s", module.getName());
        for (Parameter parameter : parameters) {
            formatter.format(" <%s>", parameter.getName());
        }
        for (Parameter parameter : optionalParameters) {
            formatter.format(" [<%s>]", parameter.getName());
        }
        for (ReturnValue returnValue : fileReturnValues) {
            formatter.format(" [<%s>]", returnValue.getName());
        }
        formatter.format("%n", new Object[0]);
        for (Parameter parameter : parameters) {
            formatter.format("  %-10s %s%n", parameter.getName(), parameter.getDescription());
        }
        for (OptionalParameter optionalParameter : optionalParameters) {
            String string = optionalParameter.getDefaultValueString();
            String extra = "";
            if (string != null) {
                extra = String.format(" The default value is '%s'.", string);
            }
            formatter.format("  %-10s %s%s%n", optionalParameter.getName(), optionalParameter.getDescription(), extra);
        }
        for (ReturnValue returnValue : fileReturnValues) {
            formatter.format("  %-10s Optional file name for writing the output to%n", returnValue.getName());
        }
        formatter.format("%n%s", module.getLongDescription());
        boolean printedHeader = false;
        for (Parameter parameter : ListUtils.union(parameters, optionalParameters)) {
            String desc = parametersTransformer.getTransformationDescription(parameter.getKlass());
            if ("".equals(desc)) continue;
            if (!printedHeader) {
                formatter.format("%n%nFormat descriptions of parameters:", new Object[0]);
            }
            printedHeader = true;
            formatter.format("%n%n%s:%n%s", parameter.getName(), desc);
        }
        formatter.close();
        return sb.toString();
    }
}

