/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.ui.ReturnValueTransformation;
import uniol.apt.ui.ReturnValueTransformationWithOptions;
import uniol.apt.ui.ReturnValuesTransformer;

public class ReturnValuesTransformerImpl
implements ReturnValuesTransformer {
    private Map<Class<?>, ReturnValueTransformation<?>> transformations = new HashMap();

    protected <T> ReturnValueTransformation<T> addTransformation(Class<T> klass, ReturnValueTransformation<T> transformation) {
        return this.transformations.put(klass, transformation);
    }

    @Override
    public <T> ReturnValueTransformation<T> getTransformation(Class<T> klass) {
        return this.transformations.get(klass);
    }

    @Override
    public <T> void transform(Writer output, Object arg, Class<T> klass) throws ModuleException, IOException {
        ReturnValueTransformation<T> transformation = this.getTransformation(klass);
        if (transformation == null) {
            output.write(arg.toString());
        } else {
            transformation.transform(output, klass.cast(arg));
        }
    }

    @Override
    public <T> void transform(Writer output, Object arg, Class<T> klass, String extraOptions) throws ModuleException, IOException {
        ReturnValueTransformation<T> transformation = this.getTransformation(klass);
        if (transformation == null) {
            output.write(arg.toString());
        } else if (transformation instanceof ReturnValueTransformationWithOptions) {
            ReturnValueTransformationWithOptions trans = (ReturnValueTransformationWithOptions)transformation;
            trans.transform(output, klass.cast(arg), extraOptions);
        } else {
            transformation.transform(output, klass.cast(arg));
        }
    }
}

