/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.module.exception.NoSuchTransformationException;
import uniol.apt.ui.AptParameterTransformation;
import uniol.apt.ui.DescribedParameterTransformation;
import uniol.apt.ui.ParameterTransformation;
import uniol.apt.ui.ParametersTransformer;
import uniol.apt.ui.StreamParameterTransformation;
import uniol.apt.ui.StreamWithOptionsParameterTransformation;

public abstract class ParametersTransformerImpl
implements ParametersTransformer {
    public static final String STANDARD_INPUT_SYMBOL = "-";
    private Map<Class<?>, ParameterTransformation<?>> transformations = new HashMap();

    protected <T> ParameterTransformation<T> addTransformation(Class<T> klass, ParameterTransformation<T> transformation) {
        return this.transformations.put(klass, transformation);
    }

    @Override
    public <T> ParameterTransformation<T> getTransformation(Class<T> klass) {
        return this.transformations.get(klass);
    }

    @Override
    public String getTransformationDescription(Class<?> klass) throws NoSuchTransformationException {
        ParameterTransformation<?> transformation = this.transformations.get(klass);
        if (transformation == null) {
            throw new NoSuchTransformationException(klass);
        }
        if (!(transformation instanceof DescribedParameterTransformation)) {
            return "";
        }
        return ((DescribedParameterTransformation)transformation).getFormatDescription();
    }

    @Override
    public Object transform(String arg, Class<?> klass) throws ModuleException {
        ParameterTransformation<?> transformation = this.transformations.get(klass);
        if (transformation == null) {
            throw new NoSuchTransformationException(klass);
        }
        AptParameterTransformation annotation = transformation.getClass().getAnnotation(AptParameterTransformation.class);
        if (annotation.fileSource()) {
            String[] tmpParts;
            String[] parts = new String[]{"", arg};
            if (transformation instanceof StreamWithOptionsParameterTransformation && (tmpParts = arg.split(":", 2)).length == 2 && !ParametersTransformerImpl.ignoreParts(tmpParts[0], tmpParts[1])) {
                parts = tmpParts;
            }
            if (STANDARD_INPUT_SYMBOL.equals(parts[1])) {
                return this.transformStream(System.in, klass, parts[0]);
            }
            return this.transformFile(parts[1], klass, parts[0]);
        }
        return this.transformString(arg, klass);
    }

    private static boolean ignoreParts(String first, String second) {
        if (first.length() != 1) {
            return false;
        }
        return !second.isEmpty() && second.charAt(0) == '\\';
    }

    @Override
    public Object transformString(String arg, Class<?> klass) throws ModuleException {
        ParameterTransformation<?> transformation = this.transformations.get(klass);
        if (transformation == null) {
            throw new NoSuchTransformationException(klass);
        }
        Object obj = transformation.transform(arg);
        if (obj == null) {
            throw new NullPointerException("Parameter transformation for class " + klass + " returned null when given the argument '" + arg + "'");
        }
        return obj;
    }

    @Override
    public Object transformStream(InputStream istr, Class<?> klass) throws ModuleException {
        return this.transformStream(istr, klass, "");
    }

    private Object transformStream(InputStream istr, Class<?> klass, String options) throws ModuleException {
        ParameterTransformation<?> transformation = this.transformations.get(klass);
        if (transformation == null) {
            throw new NoSuchTransformationException(klass);
        }
        try {
            Object obj;
            if (transformation instanceof StreamWithOptionsParameterTransformation) {
                StreamWithOptionsParameterTransformation streamTrans = (StreamWithOptionsParameterTransformation)transformation;
                obj = streamTrans.transform(istr, options);
            } else if (transformation instanceof StreamParameterTransformation) {
                StreamParameterTransformation streamTrans = (StreamParameterTransformation)transformation;
                obj = streamTrans.transform(istr);
            } else {
                obj = transformation.transform(IOUtils.toString(istr, "UTF-8"));
            }
            if (obj == null) {
                throw new NullPointerException("Parameter transformation for class " + klass + " returned null");
            }
            return obj;
        }
        catch (IOException e) {
            throw new ModuleException("Can't read stream: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object transformFile(String file, Class<?> klass, String options) throws ModuleException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            Object object = this.transformStream(stream, klass, options);
            return object;
        }
        catch (IOException e) {
            throw new ModuleException("Can't read " + file + ": " + e.getMessage());
        }
    }
}

