/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl;

import java.util.Collection;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.AptModuleRegistry;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.ui.impl.AptParametersTransformer;
import uniol.apt.ui.impl.UIUtils;

public class HelpModule
extends AbstractModule
implements Module {
    @Override
    public String getName() {
        return "help";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addOptionalParameterWithDefault("module_name", String.class, "help", "help", "Module name for which you want help", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("information", String.class, "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        String moduleName = input.getParameter("module_name", String.class);
        AptModuleRegistry registry = AptModuleRegistry.INSTANCE;
        Collection<Module> foundModules = registry.findModulesByPrefix(moduleName);
        Module module = null;
        module = foundModules.size() == 1 ? foundModules.iterator().next() : registry.findModule(moduleName);
        if (module == null) {
            throw new ModuleException("No such module: " + moduleName);
        }
        String information = UIUtils.getModuleUsage(module, AptParametersTransformer.INSTANCE);
        output.setReturnValue("information", String.class, information);
    }

    @Override
    public String getShortDescription() {
        return "Get information about a module";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.MISC};
    }
}

