/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl;

import uniol.apt.adt.PetriNetOrTransitionSystem;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.renderer.impl.DotLTSRenderer;
import uniol.apt.io.renderer.impl.DotPNRenderer;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;

public class DrawModule
extends AbstractModule
implements Module {
    @Override
    public String getName() {
        return "draw";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn_or_ts", PetriNetOrTransitionSystem.class, "The Petri net or labeled tansition system that should be examined", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("dot", String.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        PetriNetOrTransitionSystem pnorts = input.getParameter("pn_or_ts", PetriNetOrTransitionSystem.class);
        PetriNet pn = pnorts.getNet();
        TransitionSystem ts = pnorts.getTs();
        String dot = pn == null ? new DotLTSRenderer().render(ts) : new DotPNRenderer().render(pn);
        output.setReturnValue("dot", String.class, dot);
    }

    @Override
    public String getShortDescription() {
        return "Convert a Petri net or LTS to the Dot format used by Graphviz";
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.CONVERTER, Category.MISC};
    }
}

