/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.ui.impl;

import java.util.ServiceLoader;
import uniol.apt.ui.AptParameterTransformation;
import uniol.apt.ui.ParameterTransformation;
import uniol.apt.ui.impl.ParametersTransformerImpl;

public class AptParametersTransformer
extends ParametersTransformerImpl {
    public static final AptParametersTransformer INSTANCE = new AptParametersTransformer();

    private AptParametersTransformer() {
        for (ParameterTransformation transform : ServiceLoader.load(ParameterTransformation.class, this.getClass().getClassLoader())) {
            String transformName = transform.getClass().getCanonicalName();
            AptParameterTransformation annotation = transform.getClass().getAnnotation(AptParameterTransformation.class);
            if (annotation == null) {
                throw new RuntimeException(String.format("Transformation %s is not annotated with %s", transformName, AptParametersTransformer.class.getCanonicalName()));
            }
            Class<?>[] values = annotation.value();
            if (values == null || values.length == 0) {
                throw new RuntimeException(String.format("Transformation %s has an incorrect %s annotation", transformName, AptParametersTransformer.class.getCanonicalName()));
            }
            for (Class<?> klass : values) {
                ParameterTransformation<?> old = this.addTransformationUnchecked(klass, transform);
                if (old == null) continue;
                throw new RuntimeException(String.format("Multiple transformations for %s: %s and %s", klass.getCanonicalName(), transformName, old.getClass().getCanonicalName()));
            }
        }
    }

    private <T> ParameterTransformation<T> addTransformationUnchecked(Class<T> klass, ParameterTransformation<?> transformation) {
        return super.addTransformation(klass, transformation);
    }
}

