/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.pnanalysis;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.pnanalysis.RandomTNetGenerator;

public class RandomTNetGeneratorModule
extends AbstractModule
implements Module {
    @Override
    public String getName() {
        return "random_t_net_generator";
    }

    @Override
    public String getShortDescription() {
        return "Construct a T-net or T-system (if k given) of size g.";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("g", Integer.class, "maximum count of places of the returned t-net.", new String[0]);
        inputSpec.addOptionalParameterWithoutDefault("k", Integer.class, "maximum number of token of a place in the t-net.", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("t-net", PetriNet.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        Integer k = input.getParameter("k", Integer.class);
        if (k != null && k <= 0) {
            throw new ModuleException("k must be greater than zero.");
        }
        Integer g = input.getParameter("g", Integer.class);
        PetriNet result = k == null ? RandomTNetGenerator.createRandomTNet(g) : RandomTNetGenerator.createRandomTSystem(g, k);
        output.setReturnValue("t-net", PetriNet.class, result);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.GENERATOR};
    }
}

