/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.pnanalysis;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.generator.marking.MarkingNetGenerator;
import uniol.apt.generator.tnet.TNetGenerator;

public class RandomTNetGenerator {
    private RandomTNetGenerator() {
    }

    public static PetriNet createRandomTNet(int g) {
        Set set;
        Transition t;
        Set set2;
        Random r = new Random();
        int placeCount = r.nextInt(g) + 1;
        PetriNet net = new PetriNet("Random T-Net");
        net.createPlaces(placeCount);
        int transitionCount = r.nextInt(2 * placeCount + 1) + 1;
        net.createTransitions(transitionCount);
        Transition[] transitions = new Transition[net.getTransitions().size()];
        net.getTransitions().toArray(transitions);
        for (Place place : net.getPlaces()) {
            int transId = r.nextInt(transitions.length);
            net.createFlow(place, transitions[transId]);
            transId = r.nextInt(transitions.length);
            net.createFlow(transitions[transId], place);
        }
        HashSet<Transition> emptyPre = new HashSet<Transition>();
        HashSet<Transition> emptyPost = new HashSet<Transition>();
        Transition dead = null;
        for (Transition transition : transitions) {
            Set post = transition.getPostsetNodes();
            Set pre = transition.getPresetNodes();
            if (pre.isEmpty() && post.isEmpty()) {
                if (dead == null) {
                    dead = transition;
                    continue;
                }
                net.removeTransition(transition);
                continue;
            }
            if (pre.isEmpty()) {
                emptyPre.add(transition);
            }
            if (!post.isEmpty()) continue;
            emptyPost.add(transition);
        }
        if (emptyPost.size() <= emptyPre.size()) {
            for (Transition transition : emptyPost) {
                if (!emptyPre.iterator().hasNext()) continue;
                Transition t2 = (Transition)emptyPre.iterator().next();
                emptyPre.remove(t2);
                set2 = t2.getPostsetNodes();
                for (Object node : set2) {
                    net.createFlow(transition, (Node)node);
                }
                net.removeNode(t2);
            }
            for (Transition transition : emptyPre) {
                Iterator<Transition> it = net.getTransitions().iterator();
                t = null;
                while (it.hasNext() && ((t = it.next()) == dead || emptyPre.contains(t))) {
                    if (it.hasNext()) continue;
                    it = net.getTransitions().iterator();
                }
                if (t == null) continue;
                set = transition.getPostsetNodes();
                for (Node node : set) {
                    net.createFlow(t, node);
                }
                net.removeNode(transition);
            }
        } else {
            for (Transition transition : emptyPre) {
                if (!emptyPost.iterator().hasNext()) continue;
                Transition t3 = (Transition)emptyPost.iterator().next();
                emptyPost.remove(t3);
                set2 = t3.getPresetNodes();
                for (Object node : set2) {
                    net.createFlow((Node)node, transition);
                }
                net.removeNode(t3);
            }
            for (Transition transition : emptyPost) {
                Iterator<Transition> it = net.getTransitions().iterator();
                t = null;
                while (it.hasNext() && ((t = it.next()) == dead || emptyPost.contains(t))) {
                    if (it.hasNext()) continue;
                    it = net.getTransitions().iterator();
                }
                if (t == null) continue;
                set = transition.getPresetNodes();
                for (Node node : set) {
                    net.createFlow(node, t);
                }
                net.removeNode(transition);
            }
        }
        return net;
    }

    public static PetriNet createRandomTSystem(int g, int k) {
        PetriNet net = RandomTNetGenerator.createRandomTNet(g);
        if (k == 0) {
            return net;
        }
        Random r = new Random();
        for (Place place : net.getPlaces()) {
            int tokenCount = r.nextInt(k);
            place.setInitialToken(tokenCount);
        }
        return net;
    }

    public static PetriNet reservoirSampling(int g, int k) {
        TNetGenerator gen = new TNetGenerator(g, false);
        Random r = new Random();
        if (!gen.iterator().hasNext()) {
            return null;
        }
        int n = 0;
        PetriNet tnet = gen.iterator().next();
        for (PetriNet net : gen) {
            int pos;
            if ((pos = r.nextInt(++n)) != 0) continue;
            tnet = net;
        }
        MarkingNetGenerator generator = new MarkingNetGenerator(tnet, k);
        PetriNet tSystem = !generator.iterator().hasNext() ? tnet : generator.iterator().next();
        n = 0;
        for (PetriNet net : generator) {
            int pos;
            if ((pos = r.nextInt(++n)) != 0) continue;
            tSystem = net;
        }
        return tSystem;
    }
}

