/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.pnanalysis;

import uniol.apt.adt.pn.PetriNet;
import uniol.apt.module.AbstractModule;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInput;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutput;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.pnanalysis.PnAnalysis;

public class PnAnalysisModule
extends AbstractModule
implements Module {
    @Override
    public String getName() {
        return "pn_analysis";
    }

    @Override
    public String getShortDescription() {
        return "Output a T-system of size g, which has a reachability graph, which is isomorph to the reachability graph of the input Petri net";
    }

    @Override
    public void require(ModuleInputSpec inputSpec) {
        inputSpec.addParameter("pn", PetriNet.class, "The Petri net that should be examined", new String[0]);
        inputSpec.addParameter("g", Integer.class, "maximum size of places of the checked T-systems", new String[0]);
        inputSpec.addOptionalParameterWithoutDefault("k", Integer.class, "maximum number of token of the checked T-systems", new String[0]);
        inputSpec.addOptionalParameterWithDefault("randomly", String.class, "", "", "Parameter, which say, that a randomly selected T-system is checked with g as maximum size of places.", new String[0]);
    }

    @Override
    public void provide(ModuleOutputSpec outputSpec) {
        outputSpec.addReturnValue("T-system", PetriNet.class, "file", "raw");
    }

    @Override
    public void run(ModuleInput input, ModuleOutput output) throws ModuleException {
        boolean randomly = false;
        Integer k = input.getParameter("k", Integer.class);
        if (k != null && k <= 0) {
            throw new ModuleException("k must be greater than zero.");
        }
        String stringRandomly = input.getParameter("randomly", String.class);
        if (stringRandomly.equals("randomly")) {
            randomly = true;
        }
        PetriNet pn = input.getParameter("pn", PetriNet.class);
        Integer g = input.getParameter("g", Integer.class);
        PetriNet result = new PnAnalysis().checkAllIsomorphicTSystemsForPetriNet(pn, g, k, randomly);
        output.setReturnValue("T-system", PetriNet.class, result);
    }

    @Override
    public Category[] getCategories() {
        return new Category[]{Category.PN};
    }
}

