/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.pnanalysis;

import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.analysis.coverability.CoverabilityGraph;
import uniol.apt.analysis.cycles.lts.ComputeSmallestCycles;
import uniol.apt.analysis.exception.PreconditionFailedException;
import uniol.apt.analysis.exception.UnboundedException;
import uniol.apt.analysis.isomorphism.IsomorphismLogicComplex;
import uniol.apt.analysis.persistent.PersistentTS;
import uniol.apt.analysis.plain.Plain;
import uniol.apt.analysis.reversible.ReversibleTS;
import uniol.apt.analysis.separation.LargestK;
import uniol.apt.analysis.snet.SNet;
import uniol.apt.generator.marking.MarkingNetGenerator;
import uniol.apt.generator.tnet.TNetGenerator;
import uniol.apt.pnanalysis.CycleTNetIterator;
import uniol.apt.pnanalysis.RandomTNetGenerator;
import uniol.apt.util.Pair;

public class PnAnalysis {
    public PetriNet checkAllIsomorphicTSystemsForPetriNet(PetriNet pn, Integer g, Integer k, boolean randomly) throws PreconditionFailedException {
        int maxTokens;
        if (!new Plain().checkPlain(pn)) {
            throw new PreconditionFailedException("The input Petri net is not plain.");
        }
        LargestK lk = new LargestK(pn);
        if (lk.computeLargestK() < 2L) {
            throw new PreconditionFailedException("The input Petri net has no k-marking >=2.");
        }
        ComputeSmallestCycles sc = new ComputeSmallestCycles();
        CoverabilityGraph cover = CoverabilityGraph.get(pn);
        TransitionSystem reachabilitylts1 = cover.toReachabilityLTS();
        if (!sc.checkSamePVs(reachabilitylts1)) {
            throw new PreconditionFailedException("Not all smallest cycles have the same parikh vectors.");
        }
        ReversibleTS reversibleNet = new ReversibleTS(reachabilitylts1);
        reversibleNet.check();
        if (!reversibleNet.isReversible()) {
            throw new PreconditionFailedException("The input Petri net is not reversible.");
        }
        PersistentTS persistentNet = new PersistentTS(reachabilitylts1);
        if (!persistentNet.isPersistent()) {
            throw new PreconditionFailedException("The input Petri net is not persistent.");
        }
        int n = maxTokens = k == null ? 10 : k;
        if (randomly) {
            PetriNet tSystem = RandomTNetGenerator.createRandomTSystem(g, k);
            if (this.isIsomorphic(reachabilitylts1, tSystem)) {
                return tSystem;
            }
            return null;
        }
        CycleTNetIterator iteratorCycleTNets = new CycleTNetIterator(reachabilitylts1.getNodes().size(), g, k, reachabilitylts1.getInitialState().getPostsetEdges().size());
        while (iteratorCycleTNets.hasNext()) {
            PetriNet tSystem = (PetriNet)iteratorCycleTNets.next();
            if (!this.isIsomorphic(reachabilitylts1, tSystem)) continue;
            return tSystem;
        }
        for (PetriNet tNet : new TNetGenerator((int)g, false)) {
            if (new SNet(tNet).testPlainSNet()) continue;
            for (PetriNet tSystem : new MarkingNetGenerator(tNet, maxTokens)) {
                if (!this.isIsomorphic(reachabilitylts1, tSystem)) continue;
                return tSystem;
            }
        }
        return null;
    }

    private boolean isIsomorphic(TransitionSystem t1, PetriNet tSystem) throws UnboundedException {
        TransitionSystem reachabilitylts2;
        CoverabilityGraph coverTSystem = CoverabilityGraph.get(tSystem);
        try {
            reachabilitylts2 = coverTSystem.toReachabilityLTS();
        }
        catch (UnboundedException e) {
            return false;
        }
        IsomorphismLogicComplex iso = new IsomorphismLogicComplex(t1, reachabilitylts2, false);
        if (iso.isIsomorphic()) {
            return this.adjustLabels(t1, reachabilitylts2, tSystem, iso.getFinalState());
        }
        return false;
    }

    private boolean adjustLabels(TransitionSystem t1, TransitionSystem t2, PetriNet tSystem, Deque<IsomorphismLogicComplex.ExtendedState> isomorphicPairs) {
        isomorphicPairs.removeFirst();
        HashSet<String> labels = new HashSet<String>();
        HashSet<IsomorphismLogicComplex.ExtendedState> w = new HashSet<IsomorphismLogicComplex.ExtendedState>();
        LinkedList<Pair<IsomorphismLogicComplex.ExtendedState, List<IsomorphismLogicComplex.ExtendedState>>> stack1 = new LinkedList<Pair<IsomorphismLogicComplex.ExtendedState, List<IsomorphismLogicComplex.ExtendedState>>>();
        stack1.push(new Pair<IsomorphismLogicComplex.ExtendedState, List<IsomorphismLogicComplex.ExtendedState>>(isomorphicPairs.getFirst(), this.getNextIsomorphicPairs(isomorphicPairs, isomorphicPairs.getFirst(), t1, t2)));
        w.add(isomorphicPairs.getFirst());
        while (!stack1.isEmpty()) {
            List l = (List)((Pair)stack1.peek()).getSecond();
            if (!l.isEmpty()) {
                IsomorphismLogicComplex.ExtendedState firstOfL = (IsomorphismLogicComplex.ExtendedState)l.remove(0);
                State n = ((IsomorphismLogicComplex.ExtendedState)((Pair)stack1.peek()).getFirst()).getN();
                State m = ((IsomorphismLogicComplex.ExtendedState)((Pair)stack1.peek()).getFirst()).getM();
                String label = null;
                for (Arc edge : t1.getPostsetEdges(n)) {
                    if (!((State)edge.getTarget()).equals(firstOfL.getN())) continue;
                    label = edge.getLabel();
                }
                boolean transitionFound = false;
                HashMap<Arc, String> labelsToChange = new HashMap<Arc, String>();
                for (Arc arc : t2.getPostsetEdges(m)) {
                    if (!((State)arc.getTarget()).equals(firstOfL.getM())) continue;
                    if (!arc.getLabel().equals(label) && !labels.contains(arc.getLabel())) {
                        for (Arc t2Edge : t2.getEdges()) {
                            if (arc.equals(t2Edge) || !arc.getLabel().equals(t2Edge.getLabel())) continue;
                            labelsToChange.put(t2Edge, label);
                        }
                        tSystem.getTransition(arc.getLabel()).setLabel(label);
                        labelsToChange.put(arc, label);
                        labels.add(label);
                        transitionFound = true;
                        continue;
                    }
                    if (!arc.getLabel().equals(label)) continue;
                    transitionFound = true;
                }
                for (Map.Entry entry : labelsToChange.entrySet()) {
                    ((Arc)entry.getKey()).setLabel((String)entry.getValue());
                }
                if (transitionFound) {
                    if (w.contains(firstOfL)) continue;
                    w.add(firstOfL);
                    stack1.push(new Pair<IsomorphismLogicComplex.ExtendedState, List<IsomorphismLogicComplex.ExtendedState>>(firstOfL, this.getNextIsomorphicPairs(isomorphicPairs, firstOfL, t1, t2)));
                    continue;
                }
                return false;
            }
            stack1.pop();
        }
        return true;
    }

    private List<IsomorphismLogicComplex.ExtendedState> getNextIsomorphicPairs(Deque<IsomorphismLogicComplex.ExtendedState> isomorphicPairs, IsomorphismLogicComplex.ExtendedState exState, TransitionSystem t1, TransitionSystem t2) {
        LinkedList<IsomorphismLogicComplex.ExtendedState> nextIsomorphicPairs = new LinkedList<IsomorphismLogicComplex.ExtendedState>();
        for (State t1State : t1.getPostsetNodes(exState.getN())) {
            for (State t2State : t2.getPostsetNodes(exState.getM())) {
                for (IsomorphismLogicComplex.ExtendedState extendedState : isomorphicPairs) {
                    if (!extendedState.getN().equals(t1State) || !extendedState.getM().equals(t2State)) continue;
                    nextIsomorphicPairs.add(extendedState);
                }
            }
        }
        return nextIsomorphicPairs;
    }
}

