/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.pnanalysis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uniol.apt.adt.pn.Marking;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;

public class CycleTNetIterator
implements Iterator<PetriNet> {
    private final int maxPlaces;
    private final int stateNumber;
    private final int initialStateArcsSize;
    private int maxToken = -1;
    private int placesCount = 1;
    private PetriNet currentPn;
    private int currentPlacesCount;
    private boolean hasNextWasCalled;

    public CycleTNetIterator(int stateNumber, int maxPlaces, Integer maxToken, int initialStateArcsSize) {
        assert (stateNumber > 0);
        assert (maxPlaces > 0);
        this.maxPlaces = maxPlaces;
        this.stateNumber = stateNumber;
        this.initialStateArcsSize = initialStateArcsSize;
        this.hasNextWasCalled = false;
        if (maxToken != null && maxToken >= 0) {
            this.maxToken = maxToken;
        }
    }

    private static PetriNet createCycleTNet(int placesSize, int token, int initialStateArcsSize) {
        if (placesSize < initialStateArcsSize || token < initialStateArcsSize) {
            return null;
        }
        PetriNet pn = new PetriNet();
        ArrayList<Place> places = new ArrayList<Place>();
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        for (int i = 0; i < placesSize; ++i) {
            Place p = pn.createPlace();
            places.add(p);
            Transition t = pn.createTransition();
            transitions.add(t);
        }
        HashMap<String, Integer> markingMap = new HashMap<String, Integer>();
        int placesWithToken = initialStateArcsSize;
        for (Place place : places) {
            int indexOfPlace = places.indexOf(place);
            pn.createFlow((Node)transitions.get(indexOfPlace), place);
            pn.createFlow(place, (Node)transitions.get((indexOfPlace + 1) % placesSize));
            if (placesWithToken > 1) {
                markingMap.put(place.getId(), token / initialStateArcsSize);
                token -= token / initialStateArcsSize;
            } else if (placesWithToken == 1) {
                markingMap.put(place.getId(), token);
            }
            if (placesWithToken <= 0) continue;
            --placesWithToken;
        }
        pn.setInitialMarking(new Marking(pn, markingMap));
        return pn;
    }

    @Override
    public boolean hasNext() {
        this.hasNextWasCalled = true;
        this.currentPlacesCount = this.placesCount;
        while (this.currentPlacesCount <= this.maxPlaces) {
            int stateCount = 0;
            int tokenNumber = 1;
            while (stateCount <= this.stateNumber) {
                stateCount = this.computeBinomialCoeffizient(new BigInteger(String.valueOf(this.currentPlacesCount)), new BigInteger(String.valueOf(tokenNumber)));
                if (stateCount == this.stateNumber) {
                    this.currentPn = CycleTNetIterator.createCycleTNet(this.currentPlacesCount, tokenNumber, this.initialStateArcsSize);
                    if (this.currentPn == null) break;
                    return true;
                }
                if (this.currentPlacesCount != 1 && (this.maxToken == -1 || ++tokenNumber <= this.maxToken)) continue;
            }
            ++this.currentPlacesCount;
        }
        return false;
    }

    @Override
    public PetriNet next() {
        if (!this.hasNextWasCalled && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNextWasCalled = false;
        this.placesCount = this.currentPlacesCount + 1;
        return this.currentPn;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private int computeBinomialCoeffizient(BigInteger n, BigInteger k) {
        BigInteger nMinusK = (n = n.add(k).subtract(BigInteger.ONE)).subtract(k);
        if (nMinusK.compareTo(k) < 0) {
            BigInteger temp = k;
            k = nMinusK;
            nMinusK = temp;
        }
        BigInteger numerator = BigInteger.ONE;
        BigInteger denominator = BigInteger.ONE;
        BigInteger j = BigInteger.ONE;
        while (j.compareTo(k) <= 0) {
            numerator = numerator.multiply(j.add(nMinusK));
            denominator = denominator.multiply(j);
            BigInteger gcd = numerator.gcd(denominator);
            numerator = numerator.divide(gcd);
            denominator = denominator.divide(gcd);
            j = j.add(BigInteger.ONE);
        }
        return numerator.intValue();
    }
}

