/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.module.impl;

import java.util.ArrayList;
import java.util.List;
import uniol.apt.module.Module;
import uniol.apt.module.ModulePreconditionsChecker;
import uniol.apt.module.ModuleRegistry;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.module.impl.ModuleInvoker;
import uniol.apt.module.impl.ModuleUtils;
import uniol.apt.module.impl.Parameter;
import uniol.apt.module.impl.ReturnValue;

public class SimpleModulePreconditionsChecker
implements ModulePreconditionsChecker {
    @Override
    public List<Parameter> check(ModuleRegistry reg, Module mod, Object ... args) {
        List<Parameter> params = ModuleUtils.getParameters(mod);
        ArrayList<Parameter> invalidParams = new ArrayList<Parameter>();
        block0: for (Parameter param : params) {
            for (String prop : param.getProperties()) {
                ReturnValue matchingRetVal;
                boolean valid;
                Module checkingMod = this.findCheckingModule(reg, param, prop);
                if (checkingMod == null || (valid = this.checkProperty(mod, checkingMod, param, matchingRetVal = this.getMatchingReturnValue(checkingMod, prop), args))) continue;
                invalidParams.add(param);
                continue block0;
            }
        }
        return invalidParams;
    }

    public boolean isCheckingModule(Module mod, Parameter checkedParam, String prop) {
        if (this.getMatchingReturnValue(mod, prop) == null) {
            return false;
        }
        List<Parameter> params = ModuleUtils.getParameters(mod);
        if (params.size() != 1) {
            return false;
        }
        return params.get(0).getKlass().equals(checkedParam.getKlass());
    }

    public Module findCheckingModule(ModuleRegistry reg, Parameter checkedParam, String prop) {
        for (Module mod : reg.getModules()) {
            if (!this.isCheckingModule(mod, checkedParam, prop)) continue;
            return mod;
        }
        return null;
    }

    public ReturnValue getMatchingReturnValue(Module checkingMod, String prop) {
        for (ReturnValue retVal : ModuleUtils.getReturnValues(checkingMod)) {
            if (!retVal.getKlass().equals(Boolean.class) || !retVal.hasProperty(prop)) continue;
            return retVal;
        }
        return null;
    }

    public boolean checkProperty(Module checkedMod, Module checkingMod, Parameter checkedParam, ReturnValue checkingRetVal, Object ... args) {
        List<Parameter> params = ModuleUtils.getParameters(checkedMod);
        Object arg = args[params.indexOf(checkedParam)];
        ModuleInvoker invoker = new ModuleInvoker();
        try {
            List<Object> results = invoker.invoke(checkingMod, arg);
            List<ReturnValue> retVals = ModuleUtils.getReturnValues(checkingMod);
            Boolean met = (Boolean)results.get(retVals.indexOf(checkingRetVal));
            return met;
        }
        catch (ModuleException e) {
            return false;
        }
    }
}

