/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.module.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import uniol.apt.module.Category;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleInputSpec;
import uniol.apt.module.ModuleOutputSpec;
import uniol.apt.module.impl.ModuleInputImpl;
import uniol.apt.module.impl.ModuleInputSpecImpl;
import uniol.apt.module.impl.ModuleOutputImpl;
import uniol.apt.module.impl.ModuleOutputSpecImpl;
import uniol.apt.module.impl.OptionalParameter;
import uniol.apt.module.impl.Parameter;
import uniol.apt.module.impl.ReturnValue;

public class ModuleUtils {
    private ModuleUtils() {
    }

    public static List<Parameter> getParameters(Module module) {
        ModuleInputSpecImpl inputSpec = new ModuleInputSpecImpl();
        module.require(inputSpec);
        return inputSpec.getParameters();
    }

    public static List<OptionalParameter<?>> getOptionalParameters(Module module) {
        ModuleInputSpecImpl inputSpec = new ModuleInputSpecImpl();
        module.require(inputSpec);
        return inputSpec.getOptionalParameters();
    }

    public static List<Parameter> getAllParameters(Module module) {
        ModuleInputSpecImpl inputSpec = new ModuleInputSpecImpl();
        module.require(inputSpec);
        return inputSpec.getAllParameters();
    }

    public static List<ReturnValue> getReturnValues(Module module) {
        ModuleOutputSpecImpl outputSpec = new ModuleOutputSpecImpl();
        module.provide(outputSpec);
        return outputSpec.getReturnValues();
    }

    public static List<ReturnValue> getFileReturnValues(Module module) {
        List<ReturnValue> returnValues = ModuleUtils.getReturnValues(module);
        ArrayList<ReturnValue> fileReturnValues = new ArrayList<ReturnValue>();
        for (ReturnValue returnValue : returnValues) {
            if (!returnValue.hasProperty("file")) continue;
            fileReturnValues.add(returnValue);
        }
        return fileReturnValues;
    }

    public static ModuleInputImpl getModuleInput(Module module) {
        ModuleInputImpl input = new ModuleInputImpl();
        return input;
    }

    public static ModuleOutputImpl getModuleOutput(Module module) {
        ModuleOutputSpecImpl outputSpec = new ModuleOutputSpecImpl();
        module.provide(outputSpec);
        ModuleOutputImpl output = new ModuleOutputImpl(outputSpec);
        return output;
    }

    public static ModuleInputSpec getFilledInputSpec(Module module) {
        ModuleInputSpecImpl inputSpec = new ModuleInputSpecImpl();
        module.require(inputSpec);
        return inputSpec;
    }

    public static ModuleOutputSpec getFilledOutputSpec(Module module) {
        ModuleOutputSpecImpl outputSpec = new ModuleOutputSpecImpl();
        module.provide(outputSpec);
        return outputSpec;
    }

    public static List<Module> getModulesByCategory(Collection<Module> modules, Category category) {
        LinkedList<Module> modulesByCategory = new LinkedList<Module>();
        for (Module module : modules) {
            if (!Arrays.asList(module.getCategories()).contains((Object)category)) continue;
            modulesByCategory.add(module);
        }
        return modulesByCategory;
    }
}

