/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.module.impl;

import java.util.ArrayList;
import java.util.List;
import uniol.apt.module.Module;
import uniol.apt.module.exception.ModuleException;
import uniol.apt.module.exception.ModuleInvocationException;
import uniol.apt.module.impl.ModuleInputImpl;
import uniol.apt.module.impl.ModuleOutputImpl;
import uniol.apt.module.impl.ModuleUtils;
import uniol.apt.module.impl.OptionalParameter;
import uniol.apt.module.impl.Parameter;
import uniol.apt.module.impl.ReturnValue;

public class ModuleInvoker {
    public List<Object> invoke(Module module, Object ... arguments) throws ModuleException {
        List<Parameter> parameters = ModuleUtils.getParameters(module);
        List<OptionalParameter<?>> optionalParameters = ModuleUtils.getOptionalParameters(module);
        List<Parameter> allParameters = ModuleUtils.getAllParameters(module);
        if (arguments == null) {
            throw new ModuleInvocationException("Arguments can't be null");
        }
        if (arguments.length < parameters.size()) {
            throw new ModuleInvocationException("Too few arguments");
        }
        if (arguments.length > allParameters.size()) {
            throw new ModuleInvocationException("Too many arguments");
        }
        ModuleInputImpl input = new ModuleInputImpl();
        int currentArgumentsIndex = 0;
        for (Parameter parameter : parameters) {
            if (!parameter.getKlass().isInstance(arguments[currentArgumentsIndex])) {
                String errorMessage = "Wrong type for parameter " + parameter.getName();
                throw new ModuleInvocationException(errorMessage);
            }
            input.setParameter(parameter.getName(), arguments[currentArgumentsIndex++]);
        }
        for (OptionalParameter optionalParameter : optionalParameters) {
            if (currentArgumentsIndex < arguments.length) {
                if (!optionalParameter.getKlass().isInstance(arguments[currentArgumentsIndex])) {
                    String errorMessage = "Wrong type for parameter " + optionalParameter.getName();
                    throw new ModuleInvocationException(errorMessage);
                }
                input.setParameter(optionalParameter.getName(), arguments[currentArgumentsIndex++]);
                continue;
            }
            input.setParameter(optionalParameter.getName(), optionalParameter.getDefaultValue());
        }
        ModuleOutputImpl output = ModuleUtils.getModuleOutput(module);
        module.run(input, output);
        List<ReturnValue> list = ModuleUtils.getReturnValues(module);
        ArrayList<Object> values = new ArrayList<Object>();
        for (ReturnValue returnValue : list) {
            Object value = output.getValue(returnValue.getName());
            if (value != null && !returnValue.getKlass().isInstance(value)) {
                String errorMessage = "Wrong type for return value " + returnValue.getName();
                throw new ModuleInvocationException(errorMessage);
            }
            values.add(value);
        }
        return values;
    }
}

