/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.module;

import java.util.ServiceLoader;
import uniol.apt.module.AbstractModuleRegistry;
import uniol.apt.module.Module;

public class AptModuleRegistry
extends AbstractModuleRegistry {
    public static final AptModuleRegistry INSTANCE = new AptModuleRegistry();

    private AptModuleRegistry() {
        for (Module module : ServiceLoader.load(Module.class, this.getClass().getClassLoader())) {
            String moduleName = module.getClass().getCanonicalName();
            String name = module.getName();
            if (name == null || name.equals("") || !name.equals(name.toLowerCase())) {
                throw new RuntimeException(String.format("Module %s reports an invalid name: %s", moduleName, name));
            }
            Module oldModule = this.findModule(name);
            if (oldModule != null && !oldModule.getClass().equals(module.getClass())) {
                throw new RuntimeException(String.format("Different modules claim, to have name %s: %s and %s", name, oldModule.getClass().getCanonicalName(), moduleName));
            }
            this.registerModule(module);
        }
    }
}

