/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.module;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.Trie;
import org.apache.commons.collections4.trie.PatriciaTrie;
import uniol.apt.module.Module;
import uniol.apt.module.ModuleRegistry;

public abstract class AbstractModuleRegistry
implements ModuleRegistry {
    Trie<String, Module> modulesEntries = new PatriciaTrie<Module>();

    @Override
    public Module findModule(String name) {
        return (Module)this.modulesEntries.get(name);
    }

    @Override
    public Collection<Module> findModulesByPrefix(String prefix) {
        return Collections.unmodifiableCollection(this.modulesEntries.prefixMap(prefix).values());
    }

    @Override
    public Collection<Module> getModules() {
        return Collections.unmodifiableCollection(this.modulesEntries.values());
    }

    protected void registerModule(Module module) {
        this.modulesEntries.put(module.getName(), module);
    }

    protected void registerModules(Module ... modules) {
        for (Module module : modules) {
            this.registerModule(module);
        }
    }
}

