/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.impl.AbstractRenderer;
import uniol.apt.util.StringComparator;

public class SynetLTSRenderer
extends AbstractRenderer<TransitionSystem>
implements Renderer<TransitionSystem> {
    public static final String FORMAT = "synet";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("aut"));
    }

    @Override
    public void render(TransitionSystem ts, Writer writer) throws RenderException, IOException {
        writer.append(String.format("des(%d, %d, %d)", 0, ts.getEdges().size(), ts.getNodes().size()));
        writer.append("\n");
        HashMap<String, Integer> rename = new HashMap<String, Integer>();
        rename.put(ts.getInitialState().getId(), 0);
        TreeSet<String> stateNames = new TreeSet<String>(new StringComparator());
        for (State s : ts.getNodes()) {
            if (s == ts.getInitialState()) continue;
            stateNames.add(s.getId());
        }
        int id = 1;
        for (String s : stateNames) {
            rename.put(s, id++);
        }
        for (Arc e : ts.getEdges()) {
            String label = e.getLabel();
            String source = ((State)e.getSource()).getId();
            String target = ((State)e.getTarget()).getId();
            writer.append(String.format("(%s, %s, %s)%n", rename.get(source), label, rename.get(target)));
        }
    }
}

