/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.Node;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.io.renderer.impl.AbstractRenderer;

public class PnmlPNRenderer
extends AbstractRenderer<PetriNet>
implements uniol.apt.io.renderer.Renderer<PetriNet> {
    public static final String FORMAT = "pnml";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList(FORMAT, "xml"));
    }

    @Override
    public void render(PetriNet pn, Writer writer) throws IOException {
        Renderer renderer = new Renderer();
        renderer.render(pn, writer);
    }

    private static class Renderer {
        private Map<String, String> uniqueIdMap;
        private int idCounter;

        private Renderer() {
        }

        public void render(PetriNet pn, Writer writer) throws IOException {
            this.uniqueIdMap = new HashMap<String, String>();
            this.idCounter = 0;
            writer.append("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n");
            writer.append("<pnml xmlns=\"http://www.pnml.org/version-2009/grammar/pnml\">\n");
            writer.append("<net id=\"").append(this.toUniqueId(pn.getName())).append("\" type=\"http://www.pnml.org/version-2009/grammar/ptnet\">\n");
            writer.append("<page id=\"single-page\">");
            for (Place place : pn.getPlaces()) {
                writer.append("<place id=\"").append(place.getId()).append("\">\n");
                writer.append("<name>\n<text>").append(place.getId()).append("</text>\n</name>\n");
                writer.append("<initialMarking>\n").append("<text>").append(place.getInitialToken().toString()).append("</text>\n").append("</initialMarking>\n");
                writer.append("</place>\n");
            }
            for (Transition transition : pn.getTransitions()) {
                writer.append("<transition id=\"").append(this.toUniqueId(transition.getId())).append("\">\n");
                writer.append("<name>\n<text>").append(transition.getLabel()).append("</text>\n</name>\n");
                writer.append("</transition>\n");
            }
            for (Flow flow : pn.getEdges()) {
                writer.append("<arc id=\"").append(this.toUniqueId(((Node)flow.getSource()).getId())).append("-").append(this.toUniqueId(((Node)flow.getTarget()).getId())).append("\" source=\"").append(this.toUniqueId(((Node)flow.getSource()).getId())).append("\" target=\"").append(this.toUniqueId(((Node)flow.getTarget()).getId())).append("\">\n");
                writer.append("<inscription>\n<text>").append(Integer.toString(flow.getWeight())).append("</text>\n</inscription>\n");
                writer.append("</arc>\n");
            }
            writer.append("</page>\n");
            writer.append("</net>\n");
            writer.append("</pnml>");
        }

        private String toUniqueId(String id) {
            if (this.uniqueIdMap.containsKey(id)) {
                return this.uniqueIdMap.get(id);
            }
            String unique = id;
            while (this.uniqueIdMap.containsValue(unique)) {
                unique = id + "-" + this.idCounter;
                ++this.idCounter;
            }
            this.uniqueIdMap.put(id, unique);
            return unique;
        }
    }
}

