/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.impl.GenetPNRenderer;

public class PetrifyPNRenderer
extends GenetPNRenderer
implements Renderer<PetriNet> {
    @Override
    public String getFormat() {
        return "petrify";
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("g"));
    }

    @Override
    protected void verifyNet(PetriNet pn) throws RenderException {
        super.verifyNet(pn);
        for (Flow f : pn.getEdges()) {
            if (f.getWeight() == 1) continue;
            throw new RenderException("Only flow weight 1 can be expressed in the Petrify file format");
        }
        for (Place p : pn.getPlaces()) {
            if (pn.getInitialMarking().getToken(p).getValue() <= 1L) continue;
            throw new RenderException("Cannot express token counts above 1 in the initial marking in the Petrify file format");
        }
    }
}

