/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import uniol.apt.adt.ts.Arc;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.impl.AbstractRenderer;

public class PetrifyLTSRenderer
extends AbstractRenderer<TransitionSystem>
implements Renderer<TransitionSystem> {
    public static final String FORMAT = "petrify";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("g"));
    }

    @Override
    public void render(TransitionSystem ts, Writer writer) throws RenderException, IOException {
        writer.append(".inputs ");
        for (String label : ts.getAlphabet()) {
            writer.append(label).append(" ");
        }
        writer.append("\n");
        writer.append(".state graph");
        writer.append("\n");
        for (Arc e : ts.getEdges()) {
            String label = e.getLabel();
            String source = ((State)e.getSource()).getId();
            String target = ((State)e.getTarget()).getId();
            writer.append(source).append(" ").append(label).append(" ").append(target);
            writer.append("\n");
        }
        writer.append(".marking {").append(ts.getInitialState().getId()).append("}");
        writer.append("\n");
        writer.append(".end");
        writer.append("\n");
    }
}

