/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import uniol.apt.adt.INode;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.impl.AbstractRenderer;
import uniol.apt.io.renderer.impl.ThrowingErrorListener;

public class LoLAPNRenderer
extends AbstractRenderer<PetriNet>
implements Renderer<PetriNet> {
    public static final String FORMAT = "lola";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("llnet", FORMAT));
    }

    private static void verifyNet(PetriNet pn) throws RenderException {
        if (pn.getTransitions().isEmpty()) {
            throw new RenderException("Cannot express Petri nets without transitions in the LoLA  file format");
        }
        if (pn.getPlaces().isEmpty()) {
            throw new RenderException("Cannot express Petri nets without places in the LoLA  file format");
        }
        if (pn.getInitialMarking().hasOmega()) {
            throw new RenderException("Cannot express an initial marking with at least one OMEGAtoken in the LoLA file format");
        }
        LoLAPNRenderer.verifyNames(pn.getPlaces());
        LoLAPNRenderer.verifyNames(pn.getTransitions());
    }

    private static void verifyNames(Iterable<? extends INode<?, ?, ?>> list) throws RenderException {
        for (INode<?, ?, ?> node : list) {
            String name = node.getId();
            if (name.isEmpty()) {
                throw new RenderException("Empty identifiers not allowed");
            }
            String forbidden = ",;:()\t \n{}";
            for (int i = 0; i < name.length(); ++i) {
                char[] c = new char[]{name.charAt(i)};
                if (!forbidden.contains(new String(c))) continue;
                throw new RenderException("Invalid character in identifier '" + name + "'. The following characters are forbidden: ,;:()\\t \\n{}");
            }
        }
    }

    @Override
    public void render(PetriNet pn, Writer writer) throws RenderException, IOException {
        LoLAPNRenderer.verifyNet(pn);
        STGroupFile group = new STGroupFile("uniol/apt/io/renderer/impl/LoLAPN.stg");
        ST pnTemplate = group.getInstanceOf("pn");
        pnTemplate.add("name", pn.getName());
        pnTemplate.add("places", pn.getPlaces());
        for (Place p : pn.getPlaces()) {
            Token val = pn.getInitialMarking().getToken(p);
            if (val.getValue() == 0L) continue;
            pnTemplate.addAggr("marking.{place, weight}", p, val.getValue());
        }
        pnTemplate.add("transitions", pn.getTransitions());
        pnTemplate.write((STWriter)new AutoIndentWriter(writer), (STErrorListener)new ThrowingErrorListener());
    }
}

