/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.impl.AbstractRenderer;
import uniol.apt.io.renderer.impl.ThrowingErrorListener;

public class GenetPNRenderer
extends AbstractRenderer<PetriNet>
implements Renderer<PetriNet> {
    @Override
    public String getFormat() {
        return "genet";
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("g"));
    }

    protected void verifyNet(PetriNet pn) throws RenderException {
        if (pn.getInitialMarking().hasOmega()) {
            throw new RenderException("Cannot express an initial marking with at least one OMEGAtoken in the Genet file format");
        }
    }

    @Override
    public void render(PetriNet pn, Writer writer) throws RenderException, IOException {
        this.verifyNet(pn);
        STGroupFile group = new STGroupFile("uniol/apt/io/renderer/impl/GenetPN.stg");
        ST pnTemplate = group.getInstanceOf("pn");
        pnTemplate.add("name", pn.getName());
        pnTemplate.add("transitions", pn.getTransitions());
        for (Place p : pn.getPlaces()) {
            Token val = pn.getInitialMarking().getToken(p);
            if (val.getValue() == 0L) continue;
            pnTemplate.addAggr("marking.{place, token, tokenOne}", p, val, val.getValue() == 1L);
        }
        for (Flow f : pn.getEdges()) {
            pnTemplate.addAggr("edge.{source, target, weight, weightOne}", f.getSource(), f.getTarget(), f.getWeight(), f.getWeight() == 1);
        }
        pnTemplate.write((STWriter)new AutoIndentWriter(writer), (STErrorListener)new ThrowingErrorListener());
    }
}

