/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.impl.AbstractRenderer;
import uniol.apt.io.renderer.impl.ThrowingErrorListener;

public class BagginsPNRenderer
extends AbstractRenderer<PetriNet>
implements Renderer<PetriNet> {
    public static final String FORMAT = "baggins";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList(FORMAT));
    }

    private static void verifyNet(PetriNet pn) throws RenderException {
        if (pn.getTransitions().isEmpty()) {
            throw new RenderException("Cannot express Petri nets without transitions in the BAGGINS  file format");
        }
        if (pn.getPlaces().isEmpty()) {
            throw new RenderException("Cannot express Petri nets without places in the BAGGINS  file format");
        }
        if (pn.getInitialMarking().hasOmega()) {
            throw new RenderException("Cannot express an initial marking with at least one OMEGA token in the BAGGINS file format");
        }
    }

    @Override
    public void render(PetriNet pn, Writer writer) throws RenderException, IOException {
        BagginsPNRenderer.verifyNet(pn);
        STGroupFile group = new STGroupFile("uniol/apt/io/renderer/impl/BagginsPN.stg", '$', '$');
        ST pnTemplate = group.getInstanceOf("pn");
        pnTemplate.add("name", pn.getName());
        pnTemplate.add("places", pn.getPlaces());
        ArrayList<Place> placeList = new ArrayList<Place>(pn.getPlaces());
        for (Transition t : pn.getTransitions()) {
            ArrayList<IdWeightPair> preset = new ArrayList<IdWeightPair>();
            ArrayList<IdWeightPair> postset = new ArrayList<IdWeightPair>();
            for (Flow e : t.getPresetEdges()) {
                preset.add(new IdWeightPair(placeList.indexOf(e.getSource()), -e.getWeight()));
            }
            for (Flow e : t.getPostsetEdges()) {
                postset.add(new IdWeightPair(placeList.indexOf(e.getTarget()), e.getWeight()));
            }
            pnTemplate.addAggr("transitions.{transition, preset, postset}", t, preset, postset);
        }
        pnTemplate.write((STWriter)new AutoIndentWriter(writer), (STErrorListener)new ThrowingErrorListener());
    }

    private static class IdWeightPair {
        public int id;
        public int weight;

        private IdWeightPair(int id, int weight) {
            this.id = id;
            this.weight = weight;
        }
    }
}

