/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Token;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.impl.AbstractRenderer;
import uniol.apt.io.renderer.impl.ThrowingErrorListener;

public class AptPNRenderer
extends AbstractRenderer<PetriNet>
implements Renderer<PetriNet> {
    public static final String FORMAT = "apt";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("apn", FORMAT));
    }

    private static void verifyNet(PetriNet pn) throws RenderException {
        if (pn.getInitialMarking().hasOmega()) {
            throw new RenderException("Cannot express an initial marking with at least one OMEGAtoken in the APT file format");
        }
    }

    @Override
    public void render(PetriNet pn, Writer writer) throws RenderException, IOException {
        AptPNRenderer.verifyNet(pn);
        STGroupFile group = new STGroupFile("uniol/apt/io/renderer/impl/AptPN.stg");
        ST pnTemplate = group.getInstanceOf("pn");
        pnTemplate.add("name", pn.getName());
        if (pn.hasExtension("description")) {
            pnTemplate.add("description", pn.getExtension("description"));
        }
        pnTemplate.add("extensions", pn.getWriteToFileExtensions());
        pnTemplate.add("places", pn.getPlaces());
        for (Place p : pn.getPlaces()) {
            Token val = pn.getInitialMarking().getToken(p);
            if (val.getValue() == 0L) continue;
            pnTemplate.addAggr("marking.{place, weight}", p, val.getValue());
        }
        pnTemplate.add("transitions", pn.getTransitions());
        boolean haveFlowWithExtension = false;
        for (Flow flow : pn.getEdges()) {
            if (flow.getWriteToFileExtensions().isEmpty()) continue;
            haveFlowWithExtension = true;
            break;
        }
        pnTemplate.add("have_flow_with_extension", haveFlowWithExtension);
        pnTemplate.write((STWriter)new AutoIndentWriter(writer), (STErrorListener)new ThrowingErrorListener());
    }
}

