/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import uniol.apt.adt.ts.State;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.impl.AbstractRenderer;
import uniol.apt.io.renderer.impl.ThrowingErrorListener;
import uniol.apt.util.Pair;

public class AptLTSRenderer
extends AbstractRenderer<TransitionSystem>
implements Renderer<TransitionSystem> {
    public static final String FORMAT = "apt";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("ats", FORMAT));
    }

    private static Collection<Object> decorateStates(TransitionSystem ts) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(new InitialStateDecorator(ts.getInitialState()));
        for (State state : ts.getNodes()) {
            if (state.equals(ts.getInitialState())) continue;
            result.add(state);
        }
        return result;
    }

    @Override
    public void render(TransitionSystem ts, Writer writer) throws RenderException, IOException {
        STGroupFile group = new STGroupFile("uniol/apt/io/renderer/impl/AptLTS.stg");
        ST ltsTemplate = group.getInstanceOf("lts");
        ltsTemplate.add("name", ts.getName());
        if (ts.hasExtension("description")) {
            ltsTemplate.add("description", ts.getExtension("description"));
        }
        ltsTemplate.add("extensions", ts.getWriteToFileExtensions());
        ltsTemplate.add("states", AptLTSRenderer.decorateStates(ts));
        ltsTemplate.add("arcs", ts.getEdges());
        ltsTemplate.add("events", ts.getAlphabetEvents());
        ltsTemplate.write((STWriter)new AutoIndentWriter(writer), (STErrorListener)new ThrowingErrorListener());
    }

    private static class InitialStateDecorator {
        private final State decoratedState;

        public InitialStateDecorator(State state) {
            this.decoratedState = state;
        }

        public String getId() {
            return this.decoratedState.getId();
        }

        public List<Pair<String, Object>> getWriteToFileExtensions() {
            ArrayList<Pair<String, Object>> result = new ArrayList<Pair<String, Object>>(this.decoratedState.getWriteToFileExtensions());
            result.add(0, new Pair<String, String>("initial", "true"));
            return result;
        }
    }
}

