/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.STWriter;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.impl.AbstractRenderer;
import uniol.apt.io.renderer.impl.ThrowingErrorListener;

public abstract class AbstractSTRenderer<G>
extends AbstractRenderer<G> {
    private final STGroup group;
    private final String templateName;
    private final String format;
    private final String[] extensions;

    protected AbstractSTRenderer(String templateFile, String templateName, String format, String ... extensions) {
        this.group = new STGroupFile(templateFile);
        this.templateName = templateName;
        this.format = format;
        this.extensions = extensions;
    }

    @Override
    public void render(G obj, Writer writer) throws RenderException, IOException {
        ST template = this.group.getInstanceOf(this.templateName);
        template.add(this.templateName, obj);
        template.write((STWriter)new AutoIndentWriter(writer), (STErrorListener)new ThrowingErrorListener());
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList(this.extensions));
    }
}

