/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.StringBuilderWriter;
import uniol.apt.io.renderer.RenderException;
import uniol.apt.io.renderer.Renderer;

public abstract class AbstractRenderer<G>
implements Renderer<G> {
    @Override
    public void renderFile(G obj, String filename) throws RenderException, IOException {
        this.renderFile(obj, new File(filename));
    }

    @Override
    public void renderFile(G obj, File file) throws RenderException, IOException {
        try (FileOutputStream os = FileUtils.openOutputStream(file);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
             BufferedWriter bw = new BufferedWriter(osw);){
            this.render(obj, bw);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String render(G obj) throws RenderException {
        try (StringBuilderWriter writer = new StringBuilderWriter();){
            this.render(obj, writer);
            String string = ((Object)writer).toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

