/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.renderer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import uniol.apt.io.renderer.Renderer;
import uniol.apt.io.renderer.RendererNotFoundException;
import uniol.apt.io.renderer.Renderers;

public class AbstractRenderers<T>
implements Renderers<T> {
    private Map<String, Renderer<T>> renderers = new HashMap<String, Renderer<T>>();

    protected AbstractRenderers(Class<T> clazz) {
        String className = clazz.getCanonicalName();
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            Enumeration<URL> rendererNames = cl.getResources("META-INF/uniol/apt/compiler/" + Renderer.class.getCanonicalName() + "/" + className);
            while (rendererNames.hasMoreElements()) {
                InputStream is = rendererNames.nextElement().openStream();
                Throwable throwable = null;
                try {
                    LineIterator lIter = IOUtils.lineIterator(is, "UTF-8");
                    while (lIter.hasNext()) {
                        Renderer renderer;
                        Class<?> rendererClass;
                        String rendererName = lIter.next();
                        try {
                            rendererClass = cl.loadClass(rendererName);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new RuntimeException(String.format("Could not load class %s", rendererName), ex);
                        }
                        try {
                            renderer = (Renderer)rendererClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (ClassCastException | ReflectiveOperationException ex) {
                            throw new RuntimeException(String.format("Could not instantiate %s", rendererName), ex);
                        }
                        String format = renderer.getFormat();
                        if (format == null || format.equals("") || !format.equals(format.toLowerCase())) {
                            throw new RuntimeException(String.format("Renderer %s reports an invalid format: %s", rendererName, format));
                        }
                        Renderer<T> oldRenderer = this.renderers.get(format);
                        if (oldRenderer != null && !oldRenderer.getClass().equals(rendererClass)) {
                            throw new RuntimeException(String.format("Different renderers claim, to interpret format %s: %s and %s", format, oldRenderer.getClass().getCanonicalName(), rendererName));
                        }
                        this.renderers.put(format, renderer);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to discover renderers", ex);
        }
    }

    @Override
    public Renderer<T> getRenderer(String format) throws RendererNotFoundException {
        Renderer<T> renderer = this.renderers.get(format.toLowerCase());
        if (renderer == null) {
            throw new RendererNotFoundException(String.format("Renderer for format %s not found.", format));
        }
        return renderer;
    }

    @Override
    public Set<String> getSupportedFormats() {
        return this.renderers.keySet();
    }
}

