/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import uniol.apt.adt.exception.DatastructureException;
import uniol.apt.adt.extension.Extensible;
import uniol.apt.adt.extension.ExtensionProperty;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.adt.pn.Transition;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.Parser;
import uniol.apt.io.parser.impl.AbstractParser;
import uniol.apt.io.parser.impl.ParseRuntimeException;
import uniol.apt.io.parser.impl.SynetPNFormatBaseListener;
import uniol.apt.io.parser.impl.SynetPNFormatLexer;
import uniol.apt.io.parser.impl.SynetPNFormatListener;
import uniol.apt.io.parser.impl.SynetPNFormatParser;
import uniol.apt.io.parser.impl.ThrowingErrorListener;

public class SynetPNParser
extends AbstractParser<PetriNet>
implements Parser<PetriNet> {
    public static final String FORMAT = "synet";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("net"));
    }

    @Override
    public PetriNet parse(InputStream is) throws ParseException, IOException {
        SynetPNFormatParser.PnContext tree;
        ANTLRInputStream input = new ANTLRInputStream(is);
        SynetPNFormatLexer lexer = new SynetPNFormatLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new ThrowingErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        SynetPNFormatParser parser = new SynetPNFormatParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ThrowingErrorListener());
        parser.setBuildParseTree(true);
        try {
            tree = parser.pn();
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        PetriNet pn = new PetriNet();
        HashSet locations = new HashSet();
        try {
            ParseTreeWalker.DEFAULT.walk(new LocationListener(locations), tree);
            ParseTreeWalker.DEFAULT.walk(new PlaceTransitionListener(pn, locations), tree);
            ParseTreeWalker.DEFAULT.walk(new FlowListener(pn), tree);
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        catch (DatastructureException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
        return pn;
    }

    private static class FlowListener
    extends SynetPNFormatBaseListener
    implements SynetPNFormatListener {
        private final PetriNet pn;

        private FlowListener(PetriNet pn) {
            this.pn = pn;
        }

        @Override
        public void exitFlowPreset(SynetPNFormatParser.FlowPresetContext ctx) {
            int weight = 1;
            if (ctx.w != null) {
                weight = Integer.parseInt(ctx.w.getText());
            }
            this.pn.createFlow(ctx.t.getText(), ctx.p.getText(), weight);
        }

        @Override
        public void exitFlowPostset(SynetPNFormatParser.FlowPostsetContext ctx) {
            int weight = 1;
            if (ctx.w != null) {
                weight = Integer.parseInt(ctx.w.getText());
            }
            this.pn.createFlow(ctx.p.getText(), ctx.t.getText(), weight);
        }
    }

    private static class PlaceTransitionListener
    extends SynetPNFormatBaseListener
    implements SynetPNFormatListener {
        private final PetriNet pn;
        private final Set<String> locations;

        private PlaceTransitionListener(PetriNet pn, Set<String> locations) {
            this.pn = pn;
            this.locations = locations;
        }

        private static String extractPosition(ParserRuleContext ctx) {
            Token token = ctx.getStart();
            return "line " + token.getLine() + " pos " + token.getCharPositionInLine();
        }

        private void handleLocation(Extensible ext, SynetPNFormatParser.IdContext locCtx, ParserRuleContext parentCtx) {
            if (locCtx == null) {
                if (!this.locations.isEmpty()) {
                    throw new ParseRuntimeException(PlaceTransitionListener.extractPosition(parentCtx) + " Missing Location");
                }
                return;
            }
            String locText = locCtx.getText();
            if (!this.locations.contains(locText)) {
                throw new ParseRuntimeException(PlaceTransitionListener.extractPosition(locCtx) + " Unknown Location '" + locText + "'");
            }
            ext.putExtension("location", locText, ExtensionProperty.WRITE_TO_FILE);
        }

        @Override
        public void exitPlace(SynetPNFormatParser.PlaceContext ctx) {
            Place p = this.pn.createPlace(ctx.p.getText());
            this.handleLocation(p, ctx.loc, ctx);
            if (ctx.init != null) {
                long init = Integer.parseInt(ctx.init.getText());
                p.setInitialToken(init);
            }
        }

        @Override
        public void exitTransition(SynetPNFormatParser.TransitionContext ctx) {
            Transition t = this.pn.createTransition(ctx.t.getText());
            this.handleLocation(t, ctx.loc, ctx);
        }
    }

    private static class LocationListener
    extends SynetPNFormatBaseListener
    implements SynetPNFormatListener {
        private final Set<String> locations;

        private LocationListener(Set<String> locations) {
            this.locations = locations;
        }

        @Override
        public void exitLocation(SynetPNFormatParser.LocationContext ctx) {
            String loc = ctx.loc.getText();
            if (!this.locations.add(loc)) {
                throw new ParseRuntimeException("Location '" + loc + "' already exists");
            }
        }
    }
}

