/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import uniol.apt.adt.exception.DatastructureException;
import uniol.apt.adt.ts.TransitionSystem;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.Parser;
import uniol.apt.io.parser.impl.AbstractParser;
import uniol.apt.io.parser.impl.ParseRuntimeException;
import uniol.apt.io.parser.impl.SynetLTSFormatBaseListener;
import uniol.apt.io.parser.impl.SynetLTSFormatLexer;
import uniol.apt.io.parser.impl.SynetLTSFormatListener;
import uniol.apt.io.parser.impl.SynetLTSFormatParser;
import uniol.apt.io.parser.impl.ThrowingErrorListener;

public class SynetLTSParser
extends AbstractParser<TransitionSystem>
implements Parser<TransitionSystem> {
    public static final String FORMAT = "synet";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList("aut"));
    }

    @Override
    public TransitionSystem parse(InputStream is) throws ParseException, IOException {
        SynetLTSFormatParser.TsContext tree;
        ANTLRInputStream input = new ANTLRInputStream(is);
        SynetLTSFormatLexer lexer = new SynetLTSFormatLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new ThrowingErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        SynetLTSFormatParser parser = new SynetLTSFormatParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ThrowingErrorListener());
        parser.setBuildParseTree(true);
        try {
            tree = parser.ts();
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        TransitionSystem ts = new TransitionSystem();
        try {
            ParseTreeWalker.DEFAULT.walk(new StateListener(ts), tree);
            ParseTreeWalker.DEFAULT.walk(new ArcListener(ts), tree);
        }
        catch (DatastructureException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
        return ts;
    }

    private static class ArcListener
    extends SynetLTSFormatBaseListener
    implements SynetLTSFormatListener {
        private final TransitionSystem ts;

        private ArcListener(TransitionSystem ts) {
            this.ts = ts;
        }

        @Override
        public void exitTrans(SynetLTSFormatParser.TransContext ctx) {
            this.ts.createArc(ctx.from.getText(), ctx.to.getText(), ctx.event.getText());
        }
    }

    private static class StateListener
    extends SynetLTSFormatBaseListener
    implements SynetLTSFormatListener {
        private final TransitionSystem ts;
        private final Set<String> states;

        private StateListener(TransitionSystem ts) {
            this.ts = ts;
            this.states = new HashSet<String>();
        }

        @Override
        public void exitTs(SynetLTSFormatParser.TsContext ctx) {
            for (String state : this.states) {
                this.ts.createState(state);
            }
            this.ts.setInitialState(ctx.init.getText());
        }

        @Override
        public void exitTrans(SynetLTSFormatParser.TransContext ctx) {
            this.states.add(ctx.from.getText());
            this.states.add(ctx.to.getText());
        }
    }
}

