/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import uniol.apt.adt.automaton.FiniteAutomaton;
import uniol.apt.adt.automaton.FiniteAutomatonUtility;
import uniol.apt.adt.automaton.Symbol;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.Parser;
import uniol.apt.io.parser.impl.AbstractParser;
import uniol.apt.io.parser.impl.ParseRuntimeException;
import uniol.apt.io.parser.impl.RegexFormatLexer;
import uniol.apt.io.parser.impl.RegexFormatParser;
import uniol.apt.io.parser.impl.RegexFormatParserBaseListener;
import uniol.apt.io.parser.impl.ThrowingErrorListener;

public class RegexParser
extends AbstractParser<FiniteAutomaton>
implements Parser<FiniteAutomaton> {
    public static final String FORMAT = "regex";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.emptyList();
    }

    @Override
    public FiniteAutomaton parse(InputStream is) throws ParseException, IOException {
        RegexFormatParser.StartContext tree;
        ANTLRInputStream input = new ANTLRInputStream(is);
        RegexFormatLexer lexer = new RegexFormatLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new ThrowingErrorListener());
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        RegexFormatParser parser = new RegexFormatParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(new ThrowingErrorListener());
        parser.setBuildParseTree(true);
        try {
            tree = parser.start();
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        ParseTreeWalker walker = new ParseTreeWalker();
        HashSet alphabet = new HashSet();
        walker.walk(new AlphabetListener(alphabet), tree);
        RegexListener listener = new RegexListener(alphabet);
        try {
            walker.walk(listener, tree);
        }
        catch (ParseRuntimeException ex) {
            throw ex.getParseException();
        }
        return listener.getAutomaton();
    }

    private static class RegexListener
    extends RegexFormatParserBaseListener {
        private final ParseTreeProperty<FiniteAutomaton> automatons = new ParseTreeProperty();
        private final Set<Symbol> alphabet;
        private FiniteAutomaton automaton = null;

        private RegexListener(Set<Symbol> alphabet) {
            this.alphabet = alphabet;
        }

        private FiniteAutomaton getAutomaton() {
            assert (this.automaton != null);
            return this.automaton;
        }

        @Override
        public void exitStart(RegexFormatParser.StartContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.expr());
            assert (automaton != null);
            this.automaton = automaton;
        }

        @Override
        public void exitExpr(RegexFormatParser.ExprContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprOr());
            assert (automaton != null);
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprOr(RegexFormatParser.ExprOrContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.ex1);
            assert (automaton != null);
            if (ctx.ex2 != null) {
                FiniteAutomaton automaton2 = this.automatons.get(ctx.ex2);
                assert (automaton2 != null);
                automaton = FiniteAutomatonUtility.union(automaton, automaton2);
            }
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprAnd(RegexFormatParser.ExprAndContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.ex1);
            assert (automaton != null);
            if (ctx.ex2 != null) {
                FiniteAutomaton automaton2 = this.automatons.get(ctx.ex2);
                assert (automaton2 != null);
                automaton = FiniteAutomatonUtility.intersection(automaton, automaton2);
            }
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprConcat(RegexFormatParser.ExprConcatContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.ex1);
            assert (automaton != null);
            if (ctx.ex2 != null) {
                FiniteAutomaton automaton2 = this.automatons.get(ctx.ex2);
                assert (automaton2 != null);
                automaton = FiniteAutomatonUtility.concatenate(automaton, automaton2);
            }
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprRepeatStar(RegexFormatParser.ExprRepeatStarContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprNegatePrefix());
            assert (automaton != null);
            this.automatons.put(ctx, FiniteAutomatonUtility.kleeneStar(automaton));
        }

        @Override
        public void exitExprRepeatOpt(RegexFormatParser.ExprRepeatOptContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprNegatePrefix());
            assert (automaton != null);
            this.automatons.put(ctx, FiniteAutomatonUtility.optional(automaton));
        }

        @Override
        public void exitExprRepeatPlus(RegexFormatParser.ExprRepeatPlusContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprNegatePrefix());
            assert (automaton != null);
            this.automatons.put(ctx, FiniteAutomatonUtility.kleenePlus(automaton));
        }

        @Override
        public void exitExprRepeatExact(RegexFormatParser.ExprRepeatExactContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprNegatePrefix());
            assert (automaton != null);
            int x = Integer.parseInt(ctx.x.getText());
            this.automatons.put(ctx, FiniteAutomatonUtility.repeat(automaton, x, x));
        }

        @Override
        public void exitExprRepeatLeast(RegexFormatParser.ExprRepeatLeastContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprNegatePrefix());
            assert (automaton != null);
            int x = Integer.parseInt(ctx.x.getText());
            this.automatons.put(ctx, FiniteAutomatonUtility.concatenate(FiniteAutomatonUtility.repeat(automaton, x, x), FiniteAutomatonUtility.kleeneStar(automaton)));
        }

        @Override
        public void exitExprRepeatMinmax(RegexFormatParser.ExprRepeatMinmaxContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprNegatePrefix());
            assert (automaton != null);
            int x = Integer.parseInt(ctx.x.getText());
            int y = Integer.parseInt(ctx.y.getText());
            try {
                this.automatons.put(ctx, FiniteAutomatonUtility.repeat(automaton, x, y));
            }
            catch (IllegalArgumentException e) {
                throw new ParseRuntimeException("Invalid repetition specification, must satisfy min = " + x + " <= " + y + " = max", e);
            }
        }

        @Override
        public void exitExprRepeatNothing(RegexFormatParser.ExprRepeatNothingContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprNegatePrefix());
            assert (automaton != null);
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprNPDirect(RegexFormatParser.ExprNPDirectContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprId());
            assert (automaton != null);
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprNPNegate(RegexFormatParser.ExprNPNegateContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprId());
            assert (automaton != null);
            automaton = FiniteAutomatonUtility.negate(automaton, this.alphabet);
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprNPPrefix(RegexFormatParser.ExprNPPrefixContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.exprId());
            assert (automaton != null);
            automaton = FiniteAutomatonUtility.prefixClosure(automaton);
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprIdParentheses(RegexFormatParser.ExprIdParenthesesContext ctx) {
            FiniteAutomaton automaton = this.automatons.get(ctx.expr());
            assert (automaton != null);
            this.automatons.put(ctx, automaton);
        }

        @Override
        public void exitExprIdAtom(RegexFormatParser.ExprIdAtomContext ctx) {
            this.automatons.put(ctx, FiniteAutomatonUtility.getAtomicLanguage(new Symbol(ctx.ATOM().getText())));
        }

        @Override
        public void exitExprIdId(RegexFormatParser.ExprIdIdContext ctx) {
            String id = ctx.ID().getText();
            this.automatons.put(ctx, FiniteAutomatonUtility.getAtomicLanguage(new Symbol(id.substring(1, id.length() - 1))));
        }

        @Override
        public void exitExprIdEmpty(RegexFormatParser.ExprIdEmptyContext ctx) {
            this.automatons.put(ctx, FiniteAutomatonUtility.getEmptyLanguage());
        }

        @Override
        public void exitExprIdEpsilon(RegexFormatParser.ExprIdEpsilonContext ctx) {
            this.automatons.put(ctx, FiniteAutomatonUtility.getAtomicLanguage(Symbol.EPSILON));
        }
    }

    private static class AlphabetListener
    extends RegexFormatParserBaseListener {
        private final Set<Symbol> alphabet;

        private AlphabetListener(Set<Symbol> alphabet) {
            this.alphabet = alphabet;
        }

        @Override
        public void exitExprIdAtom(RegexFormatParser.ExprIdAtomContext ctx) {
            this.alphabet.add(new Symbol(ctx.ATOM().getText()));
        }

        @Override
        public void exitExprIdId(RegexFormatParser.ExprIdIdContext ctx) {
            String id = ctx.ID().getText();
            this.alphabet.add(new Symbol(id.substring(1, id.length() - 1)));
        }
    }
}

