/*
 * Decompiled with CFR 0.152.
 */
package uniol.apt.io.parser.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uniol.apt.adt.pn.Flow;
import uniol.apt.adt.pn.PetriNet;
import uniol.apt.adt.pn.Place;
import uniol.apt.io.parser.ParseException;
import uniol.apt.io.parser.impl.AbstractParser;

public class PnmlPNParser
extends AbstractParser<PetriNet>
implements uniol.apt.io.parser.Parser<PetriNet> {
    public static final String FORMAT = "pnml";
    public static final String EXTENSION_KEY_NAME = "pnmlName";

    @Override
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public List<String> getFileExtensions() {
        return Collections.unmodifiableList(Arrays.asList(FORMAT, "xml"));
    }

    @Override
    public PetriNet parse(InputStream is) throws ParseException, IOException {
        Parser parser = new Parser();
        return parser.parse(is);
    }

    private static class Parser {
        private Mode mode;
        private PetriNet pn;
        private Map<String, String> safeIdMap;
        private int idCounter;

        private Parser() {
        }

        public PetriNet parse(InputStream is) throws ParseException, IOException {
            Element net = this.getFirstNetElement(is);
            try {
                return this.parseIsoPNML(net);
            }
            catch (ParseException e) {
                ParseException exIso = e;
                try {
                    return this.parseUnpagedPNML(net, Mode.PIPE);
                }
                catch (ParseException e2) {
                    ParseException exPipe = e2;
                    try {
                        return this.parseUnpagedPNML(net, Mode.LOLA);
                    }
                    catch (ParseException e3) {
                        ParseException exLola = e3;
                        String msg = String.format("The PNML format could not be parsed by any variant of the PNML parser.\n\t(ISO)\t %s\n\t(PIPE)\t %s\n\t(LOLA)\t %s", exIso.getMessage(), exPipe.getMessage(), exLola.getMessage());
                        throw new ParseException(msg);
                    }
                }
            }
        }

        private PetriNet parseIsoPNML(Element net) throws ParseException, IOException {
            this.init(Mode.ISO, net);
            this.parsePagesForNodes(net);
            this.parsePagesForEdges(net);
            return this.pn;
        }

        private PetriNet parseUnpagedPNML(Element net, Mode mode) throws ParseException, IOException {
            this.init(mode, net);
            this.createNodes(net);
            this.createEdges(net);
            return this.pn;
        }

        private void init(Mode mode, Element net) throws ParseException {
            String pnName = this.getAttribute(net, "id");
            this.pn = new PetriNet(pnName);
            this.safeIdMap = new HashMap<String, String>();
            this.idCounter = 0;
            this.mode = mode;
            this.checkNetType(net, mode.getNetType());
        }

        private Element getFirstNetElement(InputStream is) throws ParseException, IOException {
            Document doc = this.getDocument(is);
            Element root = this.getPnmlRoot(doc);
            Element net = this.getChildElement(root, "net");
            return net;
        }

        private void checkNetType(Element net, String expectedType) throws ParseException {
            String type = net.getAttribute("type");
            if (!expectedType.equals(type)) {
                String msg = String.format("Expected net type '%s' but found '%s'", expectedType, type);
                throw new ParseException(msg);
            }
        }

        private Document getDocument(InputStream is) throws ParseException, IOException {
            DocumentBuilder builder;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new ParseException("Internal error while parsing the document", e);
            }
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }
            });
            try {
                return builder.parse(is);
            }
            catch (SAXException e) {
                throw new ParseException("Could not parse PNML XML file", e);
            }
        }

        private Element getPnmlRoot(Document doc) throws ParseException {
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals(PnmlPNParser.FORMAT)) {
                throw new ParseException("Root element isn't <pnml>");
            }
            return root;
        }

        private void parsePagesForNodes(Element parent) throws ParseException {
            List<Element> childPages = this.getChildElements(parent, "page");
            for (Element page : childPages) {
                this.createNodes(page);
                this.parsePagesForNodes(page);
            }
        }

        private void parsePagesForEdges(Element parent) throws ParseException {
            List<Element> childPages = this.getChildElements(parent, "page");
            for (Element page : childPages) {
                this.createEdges(page);
                this.parsePagesForEdges(page);
            }
        }

        private List<Element> getChildElements(Element parent, String tagName) {
            ArrayList<Element> elements = new ArrayList<Element>();
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1 || !child.getNodeName().equals(tagName)) continue;
                elements.add((Element)child);
            }
            return elements;
        }

        private Element getChildElement(Element parent, String tagName) throws ParseException {
            List<Element> elements = this.getChildElements(parent, tagName);
            if (elements.size() == 1) {
                return elements.get(0);
            }
            throw new ParseException(String.format("Expected single child <%s> of parent <%s> but found %d", tagName, parent.getTagName(), elements.size()));
        }

        private Element getOptionalChildElement(Element parent, String tagName) {
            List<Element> elements = this.getChildElements(parent, tagName);
            if (elements.size() == 1) {
                return elements.get(0);
            }
            return null;
        }

        private String getAttribute(Element elem, String attrName) throws ParseException {
            if (!elem.hasAttribute(attrName)) {
                throw new ParseException("Element <" + elem.getTagName() + "> does not have attribute " + attrName);
            }
            return elem.getAttribute(attrName);
        }

        private String getText(Element element) throws ParseException {
            Node child = element.getFirstChild();
            if (child == null || child.getNextSibling() != null) {
                throw new ParseException("Trying to get text inside of <" + element.getTagName() + ">, but this element has multiple children");
            }
            if (!(child instanceof Text)) {
                throw new ParseException("Trying to get text inside of <" + element.getTagName() + ">, but child isn't text");
            }
            return child.getNodeValue();
        }

        private void createNodes(Element page) throws ParseException {
            List<Element> places = this.getChildElements(page, "place");
            for (Element place : places) {
                this.createPlace(place);
            }
            List<Element> transitions = this.getChildElements(page, "transition");
            for (Element transition : transitions) {
                this.createTransition(transition);
            }
        }

        private void createPlace(Element place) throws ParseException {
            String id = this.toSafeIdentifier(this.getAttribute(place, "id"));
            String name = this.parseName(place);
            long initialMarking = this.parseInitialMarking(place);
            Place pnPlace = this.pn.createPlace(id);
            pnPlace.setInitialToken(initialMarking);
            if (name != null) {
                pnPlace.putExtension(PnmlPNParser.EXTENSION_KEY_NAME, name);
            }
        }

        private long parseInitialMarking(Element place) throws ParseException {
            Element initMarkElem = this.getOptionalChildElement(place, "initialMarking");
            if (initMarkElem == null) {
                return 0L;
            }
            Element textElem = this.getChildElement(initMarkElem, this.mode.getTextElementName());
            String textValue = this.getText(textElem);
            long initialMarking = this.parseLong(textValue);
            if (initialMarking < 0L) {
                throw new ParseException("Negative initial marking");
            }
            return initialMarking;
        }

        private void createTransition(Element transition) throws ParseException {
            String id = this.toSafeIdentifier(this.getAttribute(transition, "id"));
            String name = this.parseName(transition);
            if (name != null) {
                this.pn.createTransition(id, name);
            } else {
                this.pn.createTransition(id);
            }
        }

        private void createEdges(Element page) throws ParseException {
            List<Element> arcs = this.getChildElements(page, "arc");
            for (Element arc : arcs) {
                this.createArc(arc);
            }
        }

        private void createArc(Element arc) throws ParseException {
            Element insc;
            String sourceId = this.toSafeIdentifier(this.getAttribute(arc, "source"));
            String targetId = this.toSafeIdentifier(this.getAttribute(arc, "target"));
            Flow flow = this.pn.createFlow(sourceId, targetId);
            String name = this.parseName(arc);
            if (name != null) {
                flow.putExtension(PnmlPNParser.EXTENSION_KEY_NAME, name);
            }
            if ((insc = this.getOptionalChildElement(arc, "inscription")) != null) {
                Element textElem = this.getChildElement(insc, this.mode.getTextElementName());
                String textValue = this.getText(textElem);
                long weight = this.parseLong(textValue);
                if (weight > Integer.MAX_VALUE) {
                    throw new ParseException("Enountered arc weight > 2^31 - 1 which APT does not support");
                }
                flow.setWeight((int)weight);
            }
        }

        private String parseName(Element elem) throws ParseException {
            Element nameElem = this.getOptionalChildElement(elem, "name");
            if (nameElem == null) {
                return null;
            }
            Element textElem = this.getChildElement(nameElem, this.mode.getTextElementName());
            return this.getText(textElem);
        }

        private long parseLong(String str) throws ParseException {
            int index;
            if (this.mode == Mode.PIPE && (index = str.indexOf(",")) != -1) {
                str = str.substring(index + 1);
            }
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Cannot parse number " + str, e);
            }
        }

        private String toSafeIdentifier(String input) {
            if (this.safeIdMap.containsKey(input)) {
                return this.safeIdMap.get(input);
            }
            String key = input;
            input = input.replaceAll("[^a-zA-Z0-9_]", "_");
            String unique = input = input.replaceAll("^[0-9]", "_");
            while (this.safeIdMap.containsKey(unique)) {
                unique = input + "_" + this.idCounter;
                ++this.idCounter;
            }
            this.safeIdMap.put(key, unique);
            return input;
        }

        private static enum Mode {
            ISO("http://www.pnml.org/version-2009/grammar/ptnet", "text"),
            LOLA("http://www.informatik.hu-berlin.de/top/pntd/ptNetb", "text"),
            PIPE("P/T net", "value");

            private final String netType;
            private final String textElementName;

            private Mode(String netType, String textElementName) {
                this.netType = netType;
                this.textElementName = textElementName;
            }

            public String getNetType() {
                return this.netType;
            }

            public String getTextElementName() {
                return this.textElementName;
            }
        }
    }
}

